/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.util;

import java.util.Date;
import org.joda.time.Period;

public abstract class DateUtil {
    private static final String PRIOR_TEXT = "ago";
    public static final int SECONDS_IN_MINUTE = 60;
    public static final int MILISECONDS_IN_SECOND = 1000;

    private DateUtil() {
    }

    public static String getRelativePastDate(Date someDate) {
        if (someDate != null) {
            return DateUtil.getRelativePastDate(new Date(), someDate);
        }
        return "Unknown";
    }

    public static String getRelativePastDate(Date comparedTo, Date someDate) {
        if (someDate != null) {
            Period period = new Period(someDate.getTime(), comparedTo.getTime());
            StringBuffer buffer = new StringBuffer();
            int years = period.getYears();
            if (years > 0) {
                return DateUtil.formatRelativeDateItem(buffer, years, " year");
            }
            int months = period.getMonths();
            if (months > 0) {
                return DateUtil.formatRelativeDateItem(buffer, months, " month");
            }
            int weeks = period.getWeeks();
            if (weeks > 0) {
                return DateUtil.formatRelativeDateItem(buffer, weeks, " week");
            }
            int days = period.getDays();
            if (days > 0) {
                return DateUtil.formatRelativeDateItem(buffer, days, " day");
            }
            int hours = period.getHours();
            if (hours > 0) {
                return DateUtil.formatRelativeDateItem(buffer, hours, " hour");
            }
            int minutes = period.getMinutes();
            if (minutes > 0) {
                return DateUtil.formatRelativeDateItem(buffer, minutes, " minute");
            }
            int seconds = period.getSeconds();
            if (seconds > 0) {
                return DateUtil.formatRelativeDateItem(buffer, seconds, " second");
            }
            return "< 1 second ago";
        }
        return "";
    }

    private static String formatRelativeDateItem(StringBuffer buffer, int numberOfItems, String item) {
        buffer.append(numberOfItems).append(item);
        if (numberOfItems > 1) {
            buffer.append("s");
        }
        buffer.append(" ago");
        return buffer.toString();
    }
}

