/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.rest;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.VersionedVirtualFile;
import com.atlassian.theplugin.commons.crucible.api.CrucibleSession;
import com.atlassian.theplugin.commons.crucible.api.PathAndRevision;
import com.atlassian.theplugin.commons.crucible.api.UploadItem;
import com.atlassian.theplugin.commons.crucible.api.model.BasicProject;
import com.atlassian.theplugin.commons.crucible.api.model.BasicReview;
import com.atlassian.theplugin.commons.crucible.api.model.Comment;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleAction;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleFileInfo;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleVersionInfo;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldDef;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldDefBean;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFilter;
import com.atlassian.theplugin.commons.crucible.api.model.ExtendedCrucibleProject;
import com.atlassian.theplugin.commons.crucible.api.model.GeneralComment;
import com.atlassian.theplugin.commons.crucible.api.model.NewReviewItem;
import com.atlassian.theplugin.commons.crucible.api.model.PatchAnchorData;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.PredefinedFilter;
import com.atlassian.theplugin.commons.crucible.api.model.Repository;
import com.atlassian.theplugin.commons.crucible.api.model.Review;
import com.atlassian.theplugin.commons.crucible.api.model.Reviewer;
import com.atlassian.theplugin.commons.crucible.api.model.RevisionData;
import com.atlassian.theplugin.commons.crucible.api.model.State;
import com.atlassian.theplugin.commons.crucible.api.model.SvnRepository;
import com.atlassian.theplugin.commons.crucible.api.model.User;
import com.atlassian.theplugin.commons.crucible.api.model.VersionedComment;
import com.atlassian.theplugin.commons.crucible.api.model.changes.Changes;
import com.atlassian.theplugin.commons.crucible.api.rest.CrucibleRestXmlHelper;
import com.atlassian.theplugin.commons.exception.IncorrectVersionException;
import com.atlassian.theplugin.commons.remoteapi.CaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginFailedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiSessionExpiredException;
import com.atlassian.theplugin.commons.remoteapi.rest.AbstractHttpSession;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.Logger;
import com.atlassian.theplugin.commons.util.MiscUtil;
import com.atlassian.theplugin.commons.util.ProductVersionUtil;
import com.atlassian.theplugin.commons.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrucibleSessionImpl
extends AbstractHttpSession
implements CrucibleSession {
    private static final CrucibleVersionInfo MIN_VERSION_SUPPORTING_POST_LOGIN = new CrucibleVersionInfo("2.4", null);
    private static final String AUTH_SERVICE = "/rest-service/auth-v1";
    private static final String REVIEW_SERVICE = "/rest-service/reviews-v1";
    private static final String PROJECTS_SERVICE = "/rest-service/projects-v1";
    private static final String REPOSITORIES_SERVICE = "/rest-service/repositories-v1";
    private static final String SEARCH_SERVICE = "/rest-service/search-v1";
    private static final String USER_SERVICE = "/rest-service/users-v1";
    private static final String LOGIN = "/login";
    private static final String REVIEWS_IN_STATES = "?state=";
    private static final String FILTERED_REVIEWS = "/filter";
    private static final String SEARCH_REVIEWS = "/search";
    private static final String SEARCH_REVIEWS_QUERY = "?path=";
    private static final String DETAIL_REVIEW_INFO = "/details";
    private static final String ACTIONS = "/actions";
    private static final String TRANSITIONS = "/transitions";
    private static final String REVIEWERS = "/reviewers";
    private static final String REVIEW_ITEMS = "/reviewitems";
    private static final String REVISIONS = "/revisions";
    private static final String METRICS = "/metrics";
    private static final String VERSION = "/versionInfo";
    private static final String COMMENTS = "/comments";
    private static final String GENERAL_COMMENTS = "/comments/general";
    private static final String VERSIONED_COMMENTS = "/comments/versioned";
    private static final String REPLIES = "/replies";
    private static final String APPROVE_ACTION = "action:approveReview";
    private static final String SUBMIT_ACTION = "action:submitReview";
    private static final String SUMMARIZE_ACTION = "action:summarizeReview";
    private static final String ABANDON_ACTION = "action:abandonReview";
    private static final String CLOSE_ACTION = "action:closeReview";
    private static final String RECOVER_ACTION = "action:recoverReview";
    private static final String REOPEN_ACTION = "action:reopenReview";
    private static final String REJECT_ACTION = "action:rejectReview";
    private static final String TRANSITION_ACTION = "/transition?action=";
    private static final String PUBLISH_COMMENTS = "/publish";
    private static final String COMPLETE_ACTION = "/complete";
    private static final String UNCOMPLETE_ACTION = "/uncomplete";
    private static final String ADD_CHANGESET = "/addChangeset";
    private static final String ADD_REVISIONS = "/reviewitems/revisions";
    private static final String ADD_PATCH = "/addPatch";
    private static final String ADD_FILE = "/addFile";
    private static final String MARK_READ = "/markAsRead";
    private static final String MARK_LEAVE_UNREAD = "/markAsLeaveUnread";
    private static final String MARK_ALL_READ = "/markAllAsRead";
    private static final String PROJECT_EXPAND_ALLOWED_REVIEWERS = "?expand=allowedReviewers";
    private static final String CHANGES = "/changes/";
    private static final String REVIEWS_FOR_ISSUE = "/reviewsForIssue";
    private String authToken;
    private final Map<String, Repository> repositories = new HashMap<String, Repository>();
    private final Map<String, List<CustomFieldDef>> metricsDefinitions = new HashMap<String, List<CustomFieldDef>>();
    @Nullable
    private volatile CrucibleVersionInfo crucibleVersionInfo;
    private boolean loginCalled = false;
    private final Logger logger;

    public CrucibleSessionImpl(ConnectionCfg serverData, HttpSessionCallback callback, Logger logger) throws RemoteApiMalformedUrlException {
        super(serverData, callback);
        this.logger = logger;
    }

    @Override
    public void login() throws RemoteApiLoginException {
        this.loginCalled = true;
    }

    @Override
    public void login(String name, char[] aPassword) throws RemoteApiLoginException {
        this.login();
    }

    private boolean isPostLoginSupported() throws RemoteApiException {
        CrucibleVersionInfo cvi = this.getCrucibleVersionInfo();
        return cvi.compareTo(MIN_VERSION_SUPPORTING_POST_LOGIN) >= 0;
    }

    private void realLogin() throws RemoteApiLoginException {
        try {
            Document doc = this.retrieveLoginResponse();
            String exception = CrucibleSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiLoginFailedException(exception);
            }
            XPath xpath = XPath.newInstance((String)"/loginResult/token");
            List elements = xpath.selectNodes((Object)doc);
            if (elements == null) {
                throw new RemoteApiLoginException("Server did not return any authentication token");
            }
            if (elements.size() != 1) {
                throw new RemoteApiLoginException("Server returned unexpected number of authentication tokens (" + elements.size() + ")");
            }
            this.authToken = ((Element)elements.get(0)).getText();
        }
        catch (MalformedURLException e) {
            throw new RemoteApiLoginException("Malformed server URL: " + this.getBaseUrl(), e);
        }
        catch (UnknownHostException e) {
            throw new RemoteApiLoginException("Unknown host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause().getMessage().contains("maximum")) {
                throw new CaptchaRequiredException(e);
            }
            throw new RemoteApiLoginException(String.valueOf(this.getBaseUrl()) + ":" + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiLoginException("Server:" + this.getBaseUrl() + " returned malformed response", e);
        }
        catch (RemoteApiSessionExpiredException e) {
            throw new RemoteApiLoginException("Remote session expired on server:" + this.getBaseUrl(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RemoteApiLoginException("Malformed server URL: " + this.getBaseUrl(), e);
        }
        catch (RemoteApiLoginException e) {
            throw e;
        }
        catch (RemoteApiException e) {
            throw new RemoteApiLoginException(e.getMessage(), e);
        }
    }

    private Document retrieveLoginResponse() throws IOException, JDOMException, RemoteApiException {
        String loginUrl;
        String username = this.getUsername();
        String password = this.getPassword();
        if (username == null || password == null) {
            throw new RemoteApiLoginException("Corrupted configuration. Username or Password null");
        }
        String loginUrlPrefix = String.valueOf(this.getBaseUrl()) + AUTH_SERVICE + LOGIN;
        if (this.isPostLoginSupported()) {
            HashMap<String, String> form = MiscUtil.buildHashMap();
            form.put("userName", username);
            form.put("password", password);
            return this.retrievePostResponseWithForm(loginUrlPrefix, form, true);
        }
        try {
            loginUrl = String.valueOf(loginUrlPrefix) + "?userName=" + URLEncoder.encode(username, "UTF-8") + "&password=" + URLEncoder.encode(password, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLEncoding problem: " + e.getMessage());
        }
        return this.retrieveGetResponse(loginUrl);
    }

    @Override
    public void logout() {
        this.loginCalled = false;
        if (this.authToken != null) {
            this.authToken = null;
        }
    }

    @Override
    public CrucibleVersionInfo getServerVersion() throws RemoteApiException {
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + VERSION;
        try {
            Iterator iterator;
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"versionInfo");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                this.crucibleVersionInfo = CrucibleRestXmlHelper.parseVersionNode(element);
                return this.crucibleVersionInfo;
            }
            throw new RemoteApiException("No version info found in server response");
        }
        catch (UnknownHostException e) {
            throw new RemoteApiException("Unknown host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    private void updateMetricsMetadata(BasicReview review) {
        try {
            this.getMetrics(review.getMetricsVersion());
        }
        catch (RemoteApiException remoteApiException) {}
    }

    @Override
    public List<BasicReview> getReviewsInStates(List<State> states) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseUrl());
        sb.append(REVIEW_SERVICE);
        sb.append(DETAIL_REVIEW_INFO);
        if (states != null && states.size() != 0) {
            sb.append(REVIEWS_IN_STATES);
            Iterator<State> stateIterator = states.iterator();
            while (stateIterator.hasNext()) {
                State state = stateIterator.next();
                sb.append(state.value());
                if (!stateIterator.hasNext()) continue;
                sb.append(",");
            }
        }
        try {
            Document doc = this.retrieveGetResponse(sb.toString());
            XPath xpath = XPath.newInstance((String)"/detailedReviews/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<BasicReview> reviews = new ArrayList<BasicReview>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    reviews.add(this.parseBasicReview(element));
                }
            }
            for (BasicReview review : reviews) {
                this.updateMetricsMetadata(review);
            }
            return reviews;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public List<BasicReview> getAllReviews() throws RemoteApiException {
        return this.getReviewsInStates(null);
    }

    @Override
    public List<BasicReview> getReviewsForFilter(PredefinedFilter filter) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + FILTERED_REVIEWS + "/" + filter.getFilterUrl() + DETAIL_REVIEW_INFO;
            Document doc = this.retrieveGetResponse(url);
            XPath xpath = XPath.newInstance((String)"/detailedReviews/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<BasicReview> reviews = new ArrayList<BasicReview>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    reviews.add(this.parseBasicReview(element));
                }
            }
            for (BasicReview review : reviews) {
                this.updateMetricsMetadata(review);
            }
            return reviews;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    private boolean checkCustomFiltersAsGet() {
        if (this.crucibleVersionInfo == null) {
            try {
                this.getServerVersion();
            }
            catch (RemoteApiException remoteApiException) {
                return false;
            }
        }
        try {
            ProductVersionUtil version = new ProductVersionUtil(this.crucibleVersionInfo.getReleaseNumber());
            return version.greater(new ProductVersionUtil("1.6.3"));
        }
        catch (IncorrectVersionException incorrectVersionException) {
            return false;
        }
    }

    public CrucibleVersionInfo getCrucibleVersionInfo() throws RemoteApiException {
        if (this.crucibleVersionInfo != null) {
            return this.crucibleVersionInfo;
        }
        return this.getServerVersion();
    }

    @Override
    public boolean checkContentUrlAvailable() {
        if (this.crucibleVersionInfo == null) {
            try {
                this.getServerVersion();
            }
            catch (RemoteApiException remoteApiException) {
                return false;
            }
        }
        try {
            ProductVersionUtil version = new ProductVersionUtil(this.crucibleVersionInfo.getReleaseNumber());
            return version.greater(new ProductVersionUtil("1.6.6.0"));
        }
        catch (IncorrectVersionException incorrectVersionException) {
            return false;
        }
    }

    public boolean shouldTrimWikiMarkers() {
        if (this.crucibleVersionInfo == null) {
            try {
                this.getServerVersion();
            }
            catch (RemoteApiException remoteApiException) {
                return false;
            }
        }
        try {
            ProductVersionUtil version = new ProductVersionUtil(this.crucibleVersionInfo.getReleaseNumber());
            return version.greater(new ProductVersionUtil("2.1"));
        }
        catch (IncorrectVersionException incorrectVersionException) {
            return false;
        }
    }

    @Override
    public List<BasicReview> getReviewsForCustomFilter(CustomFilter filter) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        try {
            Document doc = this.checkCustomFiltersAsGet() ? this.getReviewsForCustomFilterAsGet(filter) : this.getReviewsForCustomFilterAsPost(filter);
            XPath xpath = XPath.newInstance((String)"/detailedReviews/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<BasicReview> reviews = new ArrayList<BasicReview>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    reviews.add(this.parseBasicReview(element));
                }
            }
            for (BasicReview review : reviews) {
                this.updateMetricsMetadata(review);
            }
            return reviews;
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    private Document getReviewsForCustomFilterAsPost(CustomFilter filter) throws RemoteApiException {
        Document request = CrucibleRestXmlHelper.prepareCustomFilter(filter);
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + FILTERED_REVIEWS + DETAIL_REVIEW_INFO;
            return this.retrievePostResponse(url, request);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    private Document getReviewsForCustomFilterAsGet(CustomFilter filter) throws RemoteApiException {
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + FILTERED_REVIEWS + DETAIL_REVIEW_INFO;
            String urlFilter = filter.getFilterUrl();
            if (!StringUtils.isEmpty((String)urlFilter)) {
                url = String.valueOf(url) + "?" + urlFilter;
            }
            return this.retrieveGetResponse(url);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public List<BasicReview> getAllReviewsForFile(String repoName, String path) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + SEARCH_REVIEWS + "/" + URLEncoder.encode(repoName, "UTF-8") + DETAIL_REVIEW_INFO + SEARCH_REVIEWS_QUERY + URLEncoder.encode(path, "UTF-8");
            Document doc = this.retrieveGetResponse(url);
            XPath xpath = XPath.newInstance((String)"/detailedReviews/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<BasicReview> reviews = new ArrayList<BasicReview>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    reviews.add(this.parseBasicReview(element));
                }
            }
            for (BasicReview review : reviews) {
                this.updateMetricsMetadata(review);
            }
            return reviews;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public Review getReview(PermId permId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        try {
            Iterator iterator;
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + DETAIL_REVIEW_INFO;
            Document doc = this.retrieveGetResponse(url);
            XPath xpath = XPath.newInstance((String)"/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                return this.prepareFullDetailReview(element);
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    public void fillRepositoryData(CrucibleFileInfo fileInfo) throws RemoteApiException {
        Repository repository;
        String repoName = fileInfo.getRepositoryName();
        if (repoName == null) {
            return;
        }
        String[] repoNameTokens = repoName.split(":");
        if (!this.repositories.containsKey(repoName)) {
            repository = this.getRepository(repoNameTokens.length > 1 ? repoNameTokens[1] : repoNameTokens[0]);
            this.repositories.put(repoName, repository);
        }
        if ((repository = this.repositories.get(repoName)) != null && repository instanceof SvnRepository) {
            VersionedVirtualFile newDescriptor;
            String repoPath = String.valueOf(((SvnRepository)repository).getUrl()) + "/" + ((SvnRepository)repository).getPath() + "/";
            VersionedVirtualFile oldDescriptor = fileInfo.getOldFileDescriptor();
            if (!oldDescriptor.getUrl().equals("")) {
                oldDescriptor.setRepoUrl(repoPath);
            }
            if (!(newDescriptor = fileInfo.getFileDescriptor()).getUrl().equals("")) {
                newDescriptor.setRepoUrl(repoPath);
            }
        }
    }

    private BasicReview parseBasicReview(Element element) throws RemoteApiException {
        try {
            return CrucibleRestXmlHelper.parseBasicReview(this.getBaseUrl(), element, this.shouldTrimWikiMarkers());
        }
        catch (ParseException e) {
            throw new RemoteApiException(e);
        }
    }

    private Review prepareFullDetailReview(Element element) throws RemoteApiException {
        Review review;
        try {
            review = CrucibleRestXmlHelper.parseFullReview(this.getBaseUrl(), this.getUsername(), element, this.shouldTrimWikiMarkers());
        }
        catch (ParseException e) {
            throw new RemoteApiException(e);
        }
        for (CrucibleFileInfo fileInfo : review.getFiles()) {
            this.fillRepositoryData(fileInfo);
        }
        return review;
    }

    private Changes prepareChanges(Element element) throws RemoteApiException {
        return CrucibleRestXmlHelper.parseChangesNode(element);
    }

    @Override
    public List<Reviewer> getReviewers(PermId permId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + REVIEWERS;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/reviewers/reviewer");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<Reviewer> reviewers = new ArrayList<Reviewer>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    reviewers.add(CrucibleRestXmlHelper.parseReviewerNode(element));
                }
            }
            return reviewers;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public List<User> getUsers() throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + USER_SERVICE;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/users/userData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<User> users = new ArrayList<User>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    User u = CrucibleRestXmlHelper.parseUserNode(element);
                    if (u.getDisplayName().equals("")) {
                        u = new User(u.getUsername(), u.getUsername());
                    }
                    users.add(u);
                }
            }
            return users;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public List<BasicProject> getProjects() throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + PROJECTS_SERVICE;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/projects/projectData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<BasicProject> projects = new ArrayList<BasicProject>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    projects.add(CrucibleRestXmlHelper.parseBasicProjectNode(element));
                }
            }
            return projects;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public ExtendedCrucibleProject getProject(String key) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + PROJECTS_SERVICE + "/" + key + PROJECT_EXPAND_ALLOWED_REVIEWERS;
        try {
            Iterator iterator;
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/projectData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                return CrucibleRestXmlHelper.parseProjectNode(element);
            }
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
        return null;
    }

    @Override
    public List<Repository> getRepositories() throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REPOSITORIES_SERVICE;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/repositories/repoData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<Repository> myRepositories = new ArrayList<Repository>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    myRepositories.add(CrucibleRestXmlHelper.parseRepositoryNode(element));
                }
            }
            return myRepositories;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public Repository getRepository(String repoName) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        List<Repository> myRepositories = this.getRepositories();
        for (Repository repository : myRepositories) {
            if (!repository.getName().equals(repoName)) continue;
            if (repository.getType().equals("svn")) {
                String requestUrl = String.valueOf(this.getBaseUrl()) + REPOSITORIES_SERVICE + "/" + repoName + "/svn";
                try {
                    Iterator iterator;
                    Document doc = this.retrieveGetResponse(requestUrl);
                    XPath xpath = XPath.newInstance((String)"/svnRepositoryData");
                    List elements = xpath.selectNodes((Object)doc);
                    if (elements == null || elements.isEmpty() || !(iterator = elements.iterator()).hasNext()) continue;
                    Element element = (Element)iterator.next();
                    return CrucibleRestXmlHelper.parseSvnRepositoryNode(element);
                }
                catch (IOException e) {
                    throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
                }
                catch (JDOMException e) {
                    this.throwMalformedResponseReturned(e);
                    continue;
                }
            }
            return repository;
        }
        return null;
    }

    @Override
    public Set<CrucibleFileInfo> getFiles(PermId id) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + id.getId() + REVIEW_ITEMS;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"reviewItems/reviewItem");
            List elements = xpath.selectNodes((Object)doc);
            HashSet<CrucibleFileInfo> reviewItems = new HashSet<CrucibleFileInfo>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    CrucibleFileInfo fileInfo = CrucibleRestXmlHelper.parseReviewItemNode(element);
                    this.fillRepositoryData(fileInfo);
                    reviewItems.add(fileInfo);
                }
            }
            return reviewItems;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
        catch (ParseException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        return null;
    }

    @Override
    public List<VersionedComment> getVersionedComments(Review review, CrucibleFileInfo reviewItem) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + review.getPermId().getId() + REVIEW_ITEMS + "/" + reviewItem.getPermId().getId() + COMMENTS;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"comments/versionedLineCommentData");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<VersionedComment> comments = new ArrayList<VersionedComment>();
            if (elements != null && !elements.isEmpty()) {
                Map<PermId, CrucibleFileInfo> reviewItemMap = Collections.singletonMap(reviewItem.getPermId(), reviewItem);
                for (Element element : elements) {
                    VersionedComment c = CrucibleRestXmlHelper.parseVersionedCommentNode(review, reviewItemMap, this.getUsername(), element, this.shouldTrimWikiMarkers());
                    if (c == null) continue;
                    comments.add(c);
                }
            }
            return comments;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
        catch (ParseException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        return null;
    }

    @Override
    public Comment addGeneralComment(Review review, Comment comment) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareGeneralComment(comment);
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + review.getPermId().getId() + COMMENTS;
        try {
            Iterator iterator;
            Document doc = this.retrievePostResponse(requestUrl, request);
            XPath xpath = XPath.newInstance((String)"generalCommentData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                return CrucibleRestXmlHelper.parseGeneralCommentNode(review, null, this.getUsername(), element, this.shouldTrimWikiMarkers());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public void removeComment(PermId id, Comment comment) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + id.getId() + COMMENTS + "/" + comment.getPermId().getId();
        try {
            this.retrieveDeleteResponse(requestUrl, false);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    public void updateComment(PermId id, Comment comment) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareGeneralComment(comment);
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + id.getId() + COMMENTS + "/" + comment.getPermId().getId();
        try {
            this.retrievePostResponse(requestUrl, request, false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    public void publishComment(PermId reviewId, PermId commentId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + reviewId.getId() + PUBLISH_COMMENTS;
        if (commentId != null) {
            requestUrl = String.valueOf(requestUrl) + "/" + commentId.getId();
        }
        try {
            this.retrievePostResponse(requestUrl, "", false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
        catch (RemoteApiSessionExpiredException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
    }

    @Override
    public VersionedComment addVersionedComment(Review review, PermId riId, VersionedComment comment) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareVersionedComment(riId, comment);
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + review.getPermId().getId() + REVIEW_ITEMS + "/" + riId.getId() + COMMENTS;
        try {
            Iterator iterator;
            Document doc = this.retrievePostResponse(requestUrl, request);
            XPath xpath = XPath.newInstance((String)"versionedLineCommentData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                Map<PermId, CrucibleFileInfo> fileInfoMap = Collections.singletonMap(comment.getCrucibleFileInfo().getPermId(), comment.getCrucibleFileInfo());
                return CrucibleRestXmlHelper.parseVersionedCommentNode(review, fileInfoMap, this.getUsername(), element, this.shouldTrimWikiMarkers());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
        catch (ParseException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        return null;
    }

    @Override
    @Nullable
    public Comment addReply(Review review, Comment reply) throws RemoteApiException {
        Comment parentComment;
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        if ((parentComment = reply.getParentComment()) == null) {
            throw new RemoteApiException("Reply must have a parent comment defined");
        }
        Document request = CrucibleRestXmlHelper.prepareGeneralComment(reply);
        PermId permId = review.getPermId();
        if (permId == null) {
            throw new RemoteApiException("Review must have permId defined");
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + COMMENTS + "/" + parentComment.getPermId().getId() + REPLIES;
        try {
            Iterator iterator;
            Document doc = this.retrievePostResponse(requestUrl, request);
            XPath xpath = XPath.newInstance((String)"generalCommentData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                GeneralComment receivedReply = CrucibleRestXmlHelper.parseGeneralCommentNode(review, parentComment, this.getUsername(), element, this.shouldTrimWikiMarkers());
                if (receivedReply != null) {
                    receivedReply.setReply(true);
                }
                return receivedReply;
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public void updateReply(PermId id, PermId cId, PermId rId, Comment comment) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareGeneralComment(comment);
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + id.getId() + COMMENTS + "/" + cId.getId() + REPLIES + "/" + rId.getId();
        try {
            this.retrievePostResponse(requestUrl, request, false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    @Nullable
    public BasicReview createReview(Review review) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        return this.createReviewFromPatch(review, null);
    }

    @Override
    @Nullable
    public BasicReview createSnippetReview(Review review, String snippet, String filename) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareCreateSnippetReviewNode(review, snippet, filename);
        try {
            Document doc = this.retrievePostResponse(String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE, request);
            XPath xpath = XPath.newInstance((String)"/reviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.iterator().next());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    @Nullable
    public BasicReview createReviewFromPatch(Review review, String patch) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareCreateReviewNode(review, patch);
        StringBuilder txtHolder = new StringBuilder();
        try {
            Document doc = this.retrievePostResponse(String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE, request, txtHolder);
            XPath xpath = XPath.newInstance((String)"/reviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.iterator().next());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e, txtHolder.toString());
            return null;
        }
    }

    @Override
    @Nullable
    public BasicReview createReviewFromPatch(Review review, String patch, PatchAnchorData anchorData) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareCreateReviewNode(review, patch);
        if (this.getCrucibleVersionInfo().isVersion24OrGrater() && anchorData != null) {
            CrucibleRestXmlHelper.addAnchorData(request, anchorData);
        }
        StringBuilder txtHolder = new StringBuilder();
        try {
            Document doc = this.retrievePostResponse(String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE, request, txtHolder);
            XPath xpath = XPath.newInstance((String)"/reviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.iterator().next());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e, txtHolder.toString());
            return null;
        }
    }

    private List<Element> getReviewData(Document doc) throws JDOMException {
        XPath xpath = XPath.newInstance((String)"/reviewData");
        List elements = xpath.selectNodes((Object)doc);
        return elements;
    }

    @Override
    @Nullable
    public BasicReview createReviewFromUpload(Review review, Collection<UploadItem> uploadItems) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        BasicReview newReview = this.createReviewFromPatch(review, null);
        try {
            String urlString = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + newReview.getPermId().getId() + ADD_FILE;
            for (UploadItem uploadItem : uploadItems) {
                String bogusOld = "[--item is empty--]";
                String bogusNew = "[--item deleted--]";
                byte[] oldContent = uploadItem.getOldContent();
                byte[] newContent = uploadItem.getNewContent();
                if (oldContent == null) {
                    oldContent = bogusOld.getBytes();
                }
                if (newContent == null) {
                    newContent = bogusNew.getBytes();
                }
                ByteArrayPartSource targetOldFile = new ByteArrayPartSource(uploadItem.getFileName(), oldContent);
                ByteArrayPartSource targetNewFile = new ByteArrayPartSource(uploadItem.getFileName(), newContent);
                Part[] parts = new Part[]{new FilePart("file", (PartSource)targetNewFile), new FilePart("diffFile", (PartSource)targetOldFile)};
                this.retrievePostResponse(urlString, parts, true);
            }
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
        return newReview;
    }

    @Override
    @Nullable
    public BasicReview createReviewFromRevision(Review review, List<String> revisions) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareCreateReviewNode(review, revisions);
        try {
            Document doc = this.retrievePostResponse(String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE, request);
            XPath xpath = XPath.newInstance((String)"/reviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.iterator().next());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public byte[] getFileContent(String contentUrl) throws RemoteApiException {
        return this.getFileContent(contentUrl, false);
    }

    @Override
    public byte[] getFileContent(String contentUrl, boolean ignoreBase) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        if (StringUtils.isBlank((String)contentUrl)) {
            throw new RemoteApiException("Content URL is blank");
        }
        String requestUrl = ignoreBase ? contentUrl : String.valueOf(this.getBaseUrl()) + contentUrl;
        try {
            return this.doConditionalGet(requestUrl);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(requestUrl) + ": " + e.getMessage(), e);
        }
    }

    @Override
    public List<CrucibleAction> getAvailableActions(PermId permId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + ACTIONS;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/actions/actionData");
            List elements = xpath.selectNodes((Object)doc);
            return CrucibleRestXmlHelper.parseActions(elements);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public List<CrucibleAction> getAvailableTransitions(PermId permId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + TRANSITIONS;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/transitions/actionData");
            List elements = xpath.selectNodes((Object)doc);
            return CrucibleRestXmlHelper.parseActions(elements);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    @Nullable
    public BasicReview addRevisionsToReview(PermId permId, String repository, Collection<String> revisions) throws RemoteApiException {
        return this.addChangesetRevisionsToReview(permId, repository, revisions);
    }

    @Override
    @Nullable
    public BasicReview addFileRevisionsToReview(PermId permId, String repository, List<PathAndRevision> revisions) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        if (!this.getServerVersion().isVersion21OrGreater()) {
            throw new RemoteApiException("Crucible 2.1 or newer is required");
        }
        Document request = CrucibleRestXmlHelper.prepareRevisionDataNode(repository, revisions);
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + ADD_REVISIONS;
            Document doc = this.retrievePostResponse(url, request);
            XPath xpath = XPath.newInstance((String)"/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.iterator().next());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Nullable
    private BasicReview addChangesetRevisionsToReview(PermId permId, String repository, Collection<String> revisions) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareAddChangesetNode(repository, revisions);
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + ADD_CHANGESET;
            Document doc = this.retrievePostResponse(url, request);
            XPath xpath = XPath.newInstance((String)"/reviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.iterator().next());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public void addFileToReview(PermId permId, NewReviewItem newReviewItem) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        if (!this.getServerVersion().isVersion21OrGreater()) {
            throw new RemoteApiException("Crucible 2.1 or newer is required");
        }
        Document request = CrucibleRestXmlHelper.prepareAddItemNode(newReviewItem);
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + REVIEW_ITEMS;
            this.retrievePostResponse(url, request);
            return;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return;
        }
    }

    @Override
    @Nullable
    public BasicReview addPatchToReview(PermId permId, String repository, String patch) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareAddPatchNode(repository, patch);
        try {
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + ADD_PATCH;
            Document doc = this.retrievePostResponse(url, request);
            XPath xpath = XPath.newInstance((String)"/reviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.iterator().next());
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public void addItemsToReview(PermId permId, Collection<UploadItem> uploadItems) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        try {
            String urlString = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + ADD_FILE;
            for (UploadItem uploadItem : uploadItems) {
                ByteArrayPartSource targetOldFile = new ByteArrayPartSource(uploadItem.getFileName(), uploadItem.getOldContent());
                ByteArrayPartSource targetNewFile = new ByteArrayPartSource(uploadItem.getFileName(), uploadItem.getNewContent());
                Part[] parts = new Part[]{new FilePart("file", (PartSource)targetNewFile, uploadItem.getNewContentType(), uploadItem.getNewCharset()), new FilePart("diffFile", (PartSource)targetOldFile, uploadItem.getOldContentType(), uploadItem.getOldCharset())};
                this.retrievePostResponse(urlString, parts, true);
            }
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    public void addReviewers(PermId permId, Set<String> users) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + REVIEWERS;
        String reviewers = "";
        for (String user : users) {
            if (reviewers.length() > 0) {
                reviewers = String.valueOf(reviewers) + ",";
            }
            reviewers = String.valueOf(reviewers) + user;
        }
        try {
            this.retrievePostResponse(requestUrl, reviewers, false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    public void removeReviewer(PermId permId, String username) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + REVIEWERS + "/" + username;
        try {
            this.retrieveDeleteResponse(requestUrl, false);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    private void throwMalformedResponseReturned(JDOMException e) throws RemoteApiException {
        throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": Server returned malformed response", e);
    }

    private void throwMalformedResponseReturned(JDOMException e, String responseText) throws RemoteApiException {
        throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": Server returned malformed response: \n\n" + responseText + "\n\n", e);
    }

    private static void throwNotLoggedIn() {
        throw new IllegalStateException("Calling method without calling login() first");
    }

    @Override
    public void markCommentRead(PermId reviewId, PermId commentId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + reviewId.getId() + COMMENTS + "/" + commentId.getId() + MARK_READ;
        try {
            this.retrievePostResponse(requestUrl, "", false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    public void markCommentLeaveRead(PermId reviewId, PermId commentId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + reviewId.getId() + COMMENTS + "/" + commentId.getId() + MARK_LEAVE_UNREAD;
        try {
            this.retrievePostResponse(requestUrl, "", false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    public void markAllCommentsRead(PermId reviewId) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + reviewId.getId() + COMMENTS + MARK_ALL_READ;
        try {
            this.retrievePostResponse(requestUrl, "", false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    @Nullable
    public BasicReview changeReviewState(PermId permId, CrucibleAction action) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + TRANSITION_ACTION + action.getId();
        try {
            Iterator iterator;
            Document doc = this.retrievePostResponse(requestUrl, "", true);
            XPath xpath = XPath.newInstance((String)"reviewData");
            List elements = xpath.selectNodes((Object)doc);
            BasicReview review = null;
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                return this.parseBasicReview(element);
            }
            return review;
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public void completeReview(PermId permId, boolean complete) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId();
        requestUrl = complete ? String.valueOf(requestUrl) + COMPLETE_ACTION : String.valueOf(requestUrl) + UNCOMPLETE_ACTION;
        try {
            this.retrievePostResponse(requestUrl, "", false);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
    }

    @Override
    @Nullable
    public BasicReview closeReview(PermId permId, String summarizeMessage) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        try {
            Document doc;
            if (summarizeMessage != null && !"".equals(summarizeMessage)) {
                Document request = CrucibleRestXmlHelper.prepareCloseReviewSummaryNode(summarizeMessage);
                String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + "/close";
                doc = this.retrievePostResponse(requestUrl, request);
            } else {
                String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + TRANSITION_ACTION + CLOSE_ACTION;
                doc = this.retrievePostResponse(requestUrl, "", true);
            }
            XPath xpath = XPath.newInstance((String)"reviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                return this.parseBasicReview((Element)elements.get(0));
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    public List<CustomFieldDef> getMetrics(int version) throws RemoteApiException {
        String key = Integer.toString(version);
        if (!this.metricsDefinitions.containsKey(key)) {
            if (!this.isLoggedIn()) {
                CrucibleSessionImpl.throwNotLoggedIn();
            }
            String requestUrl = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + METRICS + "/" + Integer.toString(version);
            try {
                Document doc = this.retrieveGetResponse(requestUrl);
                XPath xpath = XPath.newInstance((String)"metrics/metricsData");
                List elements = xpath.selectNodes((Object)doc);
                ArrayList<CustomFieldDefBean> metrics = new ArrayList<CustomFieldDefBean>();
                if (elements != null && !elements.isEmpty()) {
                    for (Element element : elements) {
                        metrics.add(CrucibleRestXmlHelper.parseMetricsNode(element));
                    }
                }
                this.metricsDefinitions.put(key, metrics);
            }
            catch (IOException e) {
                throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
            }
            catch (JDOMException e) {
                this.throwMalformedResponseReturned(e);
            }
        }
        return this.metricsDefinitions.get(key);
    }

    @Override
    protected void adjustHttpHeader(HttpMethod method) {
        method.addRequestHeader(new Header("Authorization", this.getAuthHeaderValue()));
    }

    @Override
    protected void preprocessResult(Document doc) throws JDOMException, RemoteApiSessionExpiredException {
    }

    @Override
    protected void preprocessMethodResult(HttpMethod method) {
    }

    private String getAuthHeaderValue() {
        return "Basic " + StringUtil.encode(String.valueOf(this.getUsername()) + ":" + this.getPassword());
    }

    private static String getExceptionMessages(Document doc) throws JDOMException {
        XPath xpath = XPath.newInstance((String)"/loginResult/error");
        List elements = xpath.selectNodes((Object)doc);
        if (elements != null && elements.size() > 0) {
            StringBuffer exceptionMsg = new StringBuffer();
            for (Element e : elements) {
                exceptionMsg.append(e.getText());
                exceptionMsg.append("\n");
            }
            return exceptionMsg.toString();
        }
        return null;
    }

    @Override
    public boolean isLoggedIn() throws RemoteApiLoginException {
        if (!this.loginCalled) {
            return false;
        }
        this.realLogin();
        return this.authToken != null;
    }

    @Override
    @Nullable
    public BasicReview addRevisionsToReviewItems(PermId permId, Collection<RevisionData> revisions) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        Document request = CrucibleRestXmlHelper.prepareRevisions(revisions);
        try {
            Iterator iterator;
            String url = String.valueOf(this.getBaseUrl()) + REVIEW_SERVICE + "/" + permId.getId() + REVIEW_ITEMS + REVISIONS;
            Document doc = this.retrievePostResponse(url, request);
            XPath xpath = XPath.newInstance((String)"/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                return this.parseBasicReview(element);
            }
            return null;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return null;
        }
    }

    @Override
    @NotNull
    public Changes getChanges(@NotNull String repository, @Nullable String oldestCsid, boolean includeOldest, @Nullable String newestCsid, boolean includeNewest, @Nullable Integer max) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        try {
            Iterator iterator;
            String url = String.valueOf(this.getBaseUrl()) + REPOSITORIES_SERVICE + CHANGES + repository + "/?";
            if (oldestCsid != null) {
                url = String.valueOf(url) + "oldestCsid=" + oldestCsid + "&includeOldest=" + Boolean.toString(includeOldest) + "&";
            }
            if (newestCsid != null) {
                url = String.valueOf(url) + "newestCsid=" + newestCsid + "&includeNewest=" + Boolean.toString(includeNewest) + "&";
            }
            if (max != null) {
                url = String.valueOf(url) + "max=" + max.toString() + "&";
            }
            Document doc = this.retrieveGetResponse(url);
            XPath xpath = XPath.newInstance((String)"/changes");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (iterator = elements.iterator()).hasNext()) {
                Element element = (Element)iterator.next();
                return this.prepareChanges(element);
            }
            xpath = XPath.newInstance((String)"/error");
            Element errorNode = (Element)xpath.selectSingleNode((Object)doc);
            if (errorNode != null) {
                CrucibleRestXmlHelper.parseErrorAndThrowIt(errorNode);
            }
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
        }
        throw new RemoteApiException("No changes returned by server.");
    }

    @Override
    @NotNull
    public List<BasicReview> getReviewsForIssue(@NotNull String jiraIssueKey, @NotNull int maxReturn) throws RemoteApiException, RemoteApiSessionExpiredException {
        if (!this.isLoggedIn()) {
            CrucibleSessionImpl.throwNotLoggedIn();
        }
        ArrayList<BasicReview> reviews = new ArrayList<BasicReview>();
        try {
            String url = String.valueOf(this.getBaseUrl()) + SEARCH_SERVICE + REVIEWS_FOR_ISSUE + "/?jiraKey=" + URLEncoder.encode(jiraIssueKey, "UTF-8") + "&maxReturn=" + maxReturn;
            Document doc = this.retrieveGetResponse(url);
            XPath xpath = XPath.newInstance((String)"/detailedReviews/detailedReviewData");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    reviews.add(this.parseBasicReview(element));
                }
            }
            for (BasicReview review : reviews) {
                this.updateMetricsMetadata(review);
            }
            return reviews;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            this.throwMalformedResponseReturned(e);
            return reviews;
        }
    }
}

