/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg;

import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.cfg.PrivateServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerIdImpl;
import com.atlassian.theplugin.commons.cfg.UserCfg;

public class JiraServerCfg
extends ServerCfg {
    private static final int HASHCODE_MAGIC = 31;
    private boolean dontUseBasicAuth = true;
    private UserCfg basicHttpUser;
    private boolean useSessionCookies = false;

    public JiraServerCfg(String name, ServerIdImpl serverId, boolean dontUseBasicAuth) {
        super(true, name, serverId);
        this.dontUseBasicAuth = dontUseBasicAuth;
    }

    public JiraServerCfg(JiraServerCfg other) {
        super(other);
        this.dontUseBasicAuth = other.dontUseBasicAuth;
        this.basicHttpUser = other.basicHttpUser;
        this.useSessionCookies = other.useSessionCookies;
    }

    public JiraServerCfg(boolean enabled, String name, ServerIdImpl serverId, boolean dontUseBasicAuth, boolean useSessionCookies) {
        super(enabled, name, serverId);
        this.dontUseBasicAuth = dontUseBasicAuth;
        this.useSessionCookies = useSessionCookies;
    }

    public JiraServerCfg(boolean enabled, String name, String url, ServerIdImpl serverId, boolean dontUseBasicAuth, boolean useSessionCookies) {
        super(enabled, name, url, serverId);
        this.dontUseBasicAuth = dontUseBasicAuth;
        this.useSessionCookies = useSessionCookies;
    }

    public ServerType getServerType() {
        return ServerType.JIRA_SERVER;
    }

    public JiraServerCfg getClone() {
        return new JiraServerCfg(this);
    }

    public boolean isDontUseBasicAuth() {
        return this.dontUseBasicAuth;
    }

    public void setDontUseBasicAuth(boolean dontUseBasicAuth) {
        this.dontUseBasicAuth = dontUseBasicAuth;
    }

    public void setBasicHttpUser(UserCfg userCfg) {
        this.basicHttpUser = userCfg;
    }

    public UserCfg getBasicHttpUser() {
        return this.basicHttpUser;
    }

    public boolean isUseSessionCookies() {
        return this.useSessionCookies;
    }

    public void setUseSessionCookies(boolean useSessionCookies) {
        this.useSessionCookies = useSessionCookies;
    }

    public PrivateServerCfgInfo createPrivateProjectConfiguration() {
        return new PrivateServerCfgInfo(this.getServerId(), this.isEnabled(), this.isUseDefaultCredentials(), this.getUsername(), this.isPasswordStored() ? this.getPassword() : null, this.useSessionCookies, !this.dontUseBasicAuth, this.basicHttpUser != null ? this.basicHttpUser.getUsername() : "", this.basicHttpUser != null ? this.basicHttpUser.getPassword() : "", this.isShared());
    }

    public void mergePrivateConfiguration(PrivateServerCfgInfo psci) {
        super.mergePrivateConfiguration(psci);
        if (psci != null) {
            this.setUseSessionCookies(psci.isUseSessionCookies());
            this.setDontUseBasicAuth(!psci.isUseHttpBasic());
            this.setBasicHttpUser(new UserCfg(psci.getBasicUsername(), psci.getBasicPassword()));
        } else {
            this.setUseSessionCookies(false);
            this.setDontUseBasicAuth(true);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JiraServerCfg that = (JiraServerCfg)o;
        if (this.useSessionCookies != that.useSessionCookies) {
            return false;
        }
        if (this.dontUseBasicAuth != that.dontUseBasicAuth) {
            return false;
        }
        return !(this.basicHttpUser != null ? !this.basicHttpUser.equals(that.basicHttpUser) : that.basicHttpUser != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.useSessionCookies ? 1 : 0);
        result = 31 * result + (this.dontUseBasicAuth ? 1 : 0);
        result = 31 * result + (this.basicHttpUser != null ? this.basicHttpUser.hashCode() : 0);
        return result;
    }
}

