/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.workingsets;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.ISpringProject;

public class WorkingSetContentProvider
implements ICommonContentProvider {
    public static final String EXTENSION_ID = "org.springframework.ide.eclipse.ui.navigator.workingsets";
    public static final String SHOW_TOP_LEVEL_WORKING_SETS = "org.springframework.ide.eclipse.ui.navigator.workingsets.showTopLevelWorkingSets";
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final int WORKING_SETS = 0;
    private static final int PROJECTS = 1;
    private WorkingSetHelper helper;
    private int rootMode = 0;
    private IExtensionStateModel extensionStateModel;
    private IPropertyChangeListener rootModeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (WorkingSetContentProvider.SHOW_TOP_LEVEL_WORKING_SETS.equals(event.getProperty())) {
                WorkingSetContentProvider.this.updateRootMode();
            }
        }
    };

    public void init(ICommonContentExtensionSite aConfig) {
        this.extensionStateModel = aConfig.getExtensionStateModel();
        this.extensionStateModel.addPropertyChangeListener(this.rootModeListener);
        this.updateRootMode();
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkingSet) {
            IWorkingSet workingSet = (IWorkingSet)parentElement;
            if (workingSet.isAggregateWorkingSet()) {
                switch (this.rootMode) {
                    case 0: {
                        IWorkingSet[] workingSets;
                        HashSet<IWorkingSet> filteredWorkingSet = new HashSet<IWorkingSet>();
                        IWorkingSet[] iWorkingSetArray = workingSets = ((AggregateWorkingSet)workingSet).getComponents();
                        int n = workingSets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWorkingSet ws = iWorkingSetArray[n2];
                            if ("org.springframework.ide.eclipse.ui.springWorkingSetPage".equals(ws.getId())) {
                                filteredWorkingSet.add(ws);
                            }
                            ++n2;
                        }
                        return filteredWorkingSet.toArray();
                    }
                    case 1: {
                        return this.filterWorkingSet(workingSet).toArray();
                    }
                }
            }
            return this.filterWorkingSet(workingSet).toArray();
        }
        return NO_CHILDREN;
    }

    private Set<ISpringProject> filterWorkingSet(IWorkingSet workingSet) {
        IAdaptable[] elements;
        HashSet<ISpringProject> projects = new HashSet<ISpringProject>();
        IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ISpringProject springProject;
            IAdaptable element = iAdaptableArray[n2];
            IProject project = (IProject)element.getAdapter(IProject.class);
            if (project == null && element instanceof IFile) {
                project = ((IFile)element).getProject();
            }
            if (project != null && (springProject = SpringCore.getModel().getProject(project)) != null) {
                projects.add(springProject);
            }
            ++n2;
        }
        return projects;
    }

    public Object getParent(Object element) {
        if (this.helper != null) {
            return this.helper.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.helper = null;
        this.extensionStateModel.removePropertyChangeListener(this.rootModeListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IWorkingSet) {
            IWorkingSet rootSet = (IWorkingSet)newInput;
            this.helper = new WorkingSetHelper(rootSet);
        }
    }

    private void updateRootMode() {
        this.rootMode = this.extensionStateModel.getBooleanProperty(SHOW_TOP_LEVEL_WORKING_SETS) ? 0 : 1;
    }

    protected class WorkingSetHelper {
        private final IWorkingSet workingSet;
        private final Map<IAdaptable, IWorkingSet> parents = new WeakHashMap<IAdaptable, IWorkingSet>();

        public WorkingSetHelper(IWorkingSet set) {
            this.workingSet = set;
            if (this.workingSet.isAggregateWorkingSet()) {
                AggregateWorkingSet aggregateSet = (AggregateWorkingSet)this.workingSet;
                IWorkingSet[] components = aggregateSet.getComponents();
                int componentIndex = 0;
                while (componentIndex < components.length) {
                    IAdaptable[] elements = components[componentIndex].getElements();
                    int elementsIndex = 0;
                    while (elementsIndex < elements.length) {
                        this.parents.put(elements[elementsIndex], components[componentIndex]);
                        ++elementsIndex;
                    }
                    this.parents.put((IAdaptable)components[componentIndex], (IWorkingSet)aggregateSet);
                    ++componentIndex;
                }
            } else {
                IAdaptable[] elements = this.workingSet.getElements();
                int elementsIndex = 0;
                while (elementsIndex < elements.length) {
                    this.parents.put(elements[elementsIndex], this.workingSet);
                    ++elementsIndex;
                }
            }
        }

        public Object getParent(Object element) {
            return this.parents.get(element);
        }
    }
}

