/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.springframework.ide.eclipse.ui.SpringUIMessages;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class ImageDescriptorRegistry {
    private HashMap<ImageDescriptor, Image> registry = new HashMap(10);
    private Display display;

    public ImageDescriptorRegistry() {
        this(SpringUIUtils.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        Assert.isNotNull((Object)display);
        this.display = display;
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = this.registry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.display == SpringUIUtils.getStandardDisplay() ? 1 : 0) != 0, (String)SpringUIMessages.ImageDescriptorRegistry_wrongDisplay);
        result = descriptor.createImage();
        if (result != null) {
            this.registry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.registry.values()) {
            image.dispose();
        }
        this.registry.clear();
    }

    private void hookDisplay() {
        this.display.disposeExec(new Runnable(){

            @Override
            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }
}

