/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.ui.views.properties.IPropertySource;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.BeansMetadataPlugin;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.ClassUtils;

public class Bean
extends Node
implements IAdaptable {
    private IBean bean;
    private Bean[] innerBeans;
    public int preferredHeight;
    private Set<IBeanProperty> extendedProperties = new LinkedHashSet<IBeanProperty>();
    private Set<IBeanConstructorArgument> extendedConstructorArgs = new LinkedHashSet<IBeanConstructorArgument>();

    public Bean() {
        super((Object)"empty");
    }

    public Bean(IBean bean) {
        super((Object)bean.getElementName());
        this.bean = bean;
    }

    public IBean getBean() {
        return this.bean;
    }

    public String getName() {
        if (this.bean != null && this.bean.isGeneratedElementName() && this.bean.getClassName() != null) {
            return "<anonymous> " + ClassUtils.getShortName((String)this.bean.getClassName());
        }
        if (this.bean != null && this.bean.isGeneratedElementName() && this.bean.getClassName() == null) {
            return "<anonymous>";
        }
        return this.bean != null ? this.bean.getElementName() : "empty";
    }

    public String getClassName() {
        return this.bean.getClassName();
    }

    public String getParentName() {
        return this.bean.getParentName();
    }

    public IFile getConfigFile() {
        return (IFile)BeansModelUtils.getConfig((IModelElement)this.bean).getElementResource();
    }

    public int getStartLine() {
        return this.bean.getElementStartLine();
    }

    public boolean hasConstructorArguments() {
        return this.getConstructorArguments().length > 0;
    }

    public ConstructorArgument[] getConstructorArguments() {
        ArrayList<ConstructorArgument> list = new ArrayList<ConstructorArgument>();
        for (IBeanConstructorArgument carg : this.bean.getConstructorArguments()) {
            list.add(new ConstructorArgument(this, carg));
        }
        for (IBeanConstructorArgument carg : this.extendedConstructorArgs) {
            list.add(new ConstructorArgument(this, carg));
        }
        return list.toArray(new ConstructorArgument[list.size()]);
    }

    public boolean hasProperties() {
        return this.getProperties().length > 0;
    }

    public Property[] getProperties() {
        ArrayList<Property> list = new ArrayList<Property>();
        for (IBeanProperty prop : this.bean.getProperties()) {
            list.add(new Property(this, prop));
        }
        for (IBeanProperty prop : BeansMetadataPlugin.getMetadataModel().getBeanProperties(this.bean)) {
            list.add(new Property(this, prop));
        }
        for (IBeanProperty prop : this.extendedProperties) {
            list.add(new Property(this, prop));
        }
        return list.toArray(new Property[list.size()]);
    }

    public Bean[] getInnerBeans() {
        if (this.innerBeans == null) {
            HashSet<Bean> innerBeans = new HashSet<Bean>();
            if (BeansUIPlugin.getDefault().getPluginPreferences().getBoolean("org.springframework.ide.eclipse.beans.ui.shouldShowInnerBeans")) {
                for (IBean b : BeansModelUtils.getInnerBeans((IModelElement)this.bean, (boolean)false)) {
                    if (!this.shouldAddBean(b)) continue;
                    innerBeans.add(new Bean(b));
                }
            }
            this.innerBeans = innerBeans.toArray(new Bean[innerBeans.size()]);
        }
        return this.innerBeans;
    }

    private boolean shouldAddBean(IBean bean) {
        return !bean.isInfrastructure() || bean.isInfrastructure() && BeansUIPlugin.getDefault().getPluginPreferences().getBoolean("org.springframework.ide.eclipse.beans.ui.shouldShowInfrastructureBeans");
    }

    public void addBeanProperty(IBeanProperty beanProperty) {
        this.extendedProperties.add(beanProperty);
    }

    public void addBeanConstructorArgument(IBeanConstructorArgument constructorArgument) {
        this.extendedConstructorArgs.add(constructorArgument);
    }

    public boolean isRootBean() {
        return this.bean.isRootBean();
    }

    public boolean isChildBean() {
        return this.bean.isChildBean();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return BeansUIUtils.getPropertySource((IModelElement)this.bean);
        }
        return null;
    }

    public String toString() {
        return "Bean '" + this.getName() + "': x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height;
    }
}

