/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.livebean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansModel;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansModelGenerator;
import org.springframework.ide.eclipse.beans.ui.livegraph.views.LiveBeansGraphView;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.livebean.JmxBeanSupport;
import org.springframework.ide.eclipse.boot.util.StringUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.actions.AbstractActionDelegate;
import org.springsource.ide.eclipse.commons.ui.launch.LaunchUtils;

public class OpenLiveBeansGraphAction
extends AbstractActionDelegate {
    private static final String HOST = "127.0.0.1";

    public void selectionChanged(IAction action, ISelection sel) {
        super.selectionChanged(action, sel);
        action.setEnabled(BootPropertyTester.isBootProject((IProject)this.getSelectedProject()));
    }

    private IProject getSelectedProject() {
        List projects = this.getSelectedProjects();
        if (projects != null && !projects.isEmpty()) {
            return (IProject)projects.get(0);
        }
        return null;
    }

    public void run(IAction action) {
        try {
            IProject project = this.getSelectedProject();
            this.connectToProject(project);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)(String.valueOf(ExceptionUtil.getMessage((Throwable)e)) + "\n\n" + "Check the error log for more details"));
        }
    }

    private void connectToProject(IProject project) {
        try {
            String serviceUrl = this.getServiceUrl(project);
            if (serviceUrl == null) {
                throw ExceptionUtil.coreException((String)("Didn't find a JMX-enabled process for project '" + project.getName() + "'\n" + "To open the livebeans graph a process must be run with the following or similar VM arguments:\n\n" + JmxBeanSupport.jmxBeanVmArgs("${jmxPort}", EnumSet.of(JmxBeanSupport.Feature.LIVE_BEAN_GRAPH))));
            }
            LiveBeansModel model = LiveBeansModelGenerator.connectToModel((String)serviceUrl, null, null, (String)"", (IProject)project);
            IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.springframework.ide.eclipse.beans.ui.livegraph.views.LiveBeansGraphView");
            if (part instanceof LiveBeansGraphView) {
                ((LiveBeansGraphView)part).setInput(model);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)(String.valueOf(ExceptionUtil.getMessage((Throwable)e)) + "\n\n" + "Check the error log for more details"));
        }
    }

    private String getServiceUrl(IProject project) throws CoreException {
        boolean hasActiveProcess = false;
        for (ILaunchConfiguration c : OpenLiveBeansGraphAction.getLaunchConfigs(project)) {
            String jmxPortProp = this.getActiveJMXPort(c);
            for (ILaunch l : LaunchUtils.getLaunches((ILaunchConfiguration)c)) {
                if (l.isTerminated()) continue;
                hasActiveProcess = true;
                if (jmxPortProp == null) continue;
                return "service:jmx:rmi:///jndi/rmi://127.0.0.1:" + jmxPortProp + "/jmxrmi";
            }
        }
        if (hasActiveProcess) {
            throw ExceptionUtil.coreException((String)("Didn't find a JMX-enabled process for project '" + project.getName() + "'\n" + "To open the livebeans graph a process must be run with the following VM arguments:\n\n" + JmxBeanSupport.jmxBeanVmArgs("${jmxPort}", EnumSet.of(JmxBeanSupport.Feature.LIVE_BEAN_GRAPH))));
        }
        throw ExceptionUtil.coreException((String)("No active process found for project '" + project.getName() + "'\n" + "The Live Bean Graph is created at runtime. The project must be running to open it.\n" + "Run your project with the 'Run As >> Spring Boot App' context menu then try opening the view again."));
    }

    private String getActiveJMXPort(ILaunchConfiguration c) {
        String port;
        if (BootLaunchConfigurationDelegate.getEnableLiveBeanSupport(c) && StringUtil.hasText((String)(port = BootLaunchConfigurationDelegate.getJMXPort(c)))) {
            return port;
        }
        return this.getVMSystemProp(c, "com.sun.management.jmxremote.port");
    }

    private String getVMSystemProp(ILaunchConfiguration c, String propName) {
        try {
            String vmArgs = c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            if (vmArgs != null) {
                String[] pieces = DebugPlugin.parseArguments((String)vmArgs);
                String lookFor = "-D" + propName + "=";
                String[] stringArray = pieces;
                int n = pieces.length;
                int n2 = 0;
                while (n2 < n) {
                    String piece = stringArray[n2];
                    if (piece.startsWith(lookFor)) {
                        return piece.substring(lookFor.length());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    private static List<ILaunchConfiguration> getLaunchConfigs(IProject project) {
        String ctypeId = "org.springframework.ide.eclipse.boot.launch";
        ILaunchConfigurationType ctype = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(ctypeId);
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(ctype);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(project.getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
        }
        return candidateConfigs;
    }
}

