/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.views.actions;

import org.eclipse.angularjs.core.AngularElement;
import org.eclipse.angularjs.core.Module;
import org.eclipse.angularjs.core.link.AngularLinkHelper;
import org.eclipse.angularjs.internal.ui.AngularUIMessages;
import org.eclipse.angularjs.internal.ui.ImageResource;
import org.eclipse.angularjs.internal.ui.views.AngularExplorerView;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import tern.scriptpath.ITernScriptPath;

public class UnLinkToControllerAction
extends Action {
    private final AngularExplorerView explorer;

    public UnLinkToControllerAction(AngularExplorerView explorer) {
        this.explorer = explorer;
        super.setText(AngularUIMessages.UnLinkToControllerAction_text);
        super.setToolTipText(AngularUIMessages.UnLinkToControllerAction_tooltip);
        super.setImageDescriptor(ImageResource.getImageDescriptor("unlink_to_ctrl"));
    }

    public void run() {
        IStructuredSelection selection;
        IResource resource = this.explorer.getCurrentResource();
        if (resource != null && !(selection = (IStructuredSelection)this.explorer.getViewer().getSelection()).isEmpty()) {
            Object firstSelection = selection.getFirstElement();
            Module module = null;
            AngularElement controller = null;
            String elementId = null;
            if (firstSelection instanceof Module) {
                module = (Module)firstSelection;
            } else if (firstSelection instanceof AngularElement) {
                controller = (AngularElement)firstSelection;
                module = controller.getModule();
            }
            if (module != null) {
                try {
                    AngularLinkHelper.removeController((IResource)resource, (ITernScriptPath)module.getScriptPath(), (String)module.getName(), (String)(controller != null ? controller.getName() : null), elementId);
                    this.explorer.updateEnabledLinkActions(true);
                    this.explorer.refreshTree(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

