/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.views.actions;

import org.eclipse.angularjs.core.AngularElement;
import org.eclipse.angularjs.core.Module;
import org.eclipse.angularjs.core.link.AngularLinkHelper;
import org.eclipse.angularjs.internal.ui.AngularUIMessages;
import org.eclipse.angularjs.internal.ui.ImageResource;
import org.eclipse.angularjs.internal.ui.views.AngularExplorerView;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import tern.scriptpath.ITernScriptPath;

public class LinkToControllerAction
extends Action {
    private final AngularExplorerView explorer;

    public LinkToControllerAction(AngularExplorerView explorer) {
        this.explorer = explorer;
        super.setText(AngularUIMessages.LinkToControllerAction_text);
        super.setToolTipText(AngularUIMessages.LinkToControllerAction_tooltip);
        super.setImageDescriptor(ImageResource.getImageDescriptor("link_to_ctrl"));
    }

    public void run() {
        IStructuredSelection selection;
        IResource resource = this.explorer.getCurrentResource();
        if (resource != null && !(selection = (IStructuredSelection)this.explorer.getViewer().getSelection()).isEmpty()) {
            Module module = null;
            AngularElement angularElement = null;
            String elementId = null;
            Object firstSelection = selection.getFirstElement();
            if (firstSelection instanceof Module) {
                module = (Module)firstSelection;
            } else if (firstSelection instanceof AngularElement) {
                angularElement = (AngularElement)firstSelection;
                module = angularElement.getModule();
            }
            if (module != null) {
                try {
                    AngularLinkHelper.setController((ITernScriptPath)module.getScriptPath(), (String)module.getName(), (String)(angularElement != null ? angularElement.getName() : null), (IResource)resource, elementId);
                    this.explorer.updateEnabledLinkActions(true);
                    this.explorer.refreshTree(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

