/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.views.actions;

import org.eclipse.angularjs.core.AngularElement;
import org.eclipse.angularjs.core.BaseModel;
import org.eclipse.angularjs.internal.ui.AngularUIMessages;
import org.eclipse.angularjs.internal.ui.AngularUIPlugin;
import org.eclipse.angularjs.internal.ui.ImageResource;
import org.eclipse.angularjs.internal.ui.views.AngularExplorerView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class LexicalSortingAction
extends Action {
    private final AngularExplorerView explorer;
    private LexicalSorter sorter;

    public LexicalSortingAction(AngularExplorerView explorer) {
        super(AngularUIMessages.LexicalSortingAction_text, 2);
        this.explorer = explorer;
        this.sorter = new LexicalSorter();
        super.setToolTipText(AngularUIMessages.LexicalSortingAction_tooltip);
        super.setDescription(AngularUIMessages.LexicalSortingAction_description);
        super.setImageDescriptor(ImageResource.getImageDescriptor("alphab_sort_co"));
        boolean checked = AngularUIPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
        this.valueChanged(checked, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(final boolean on, boolean store) {
        this.setChecked(on);
        BusyIndicator.showWhile((Display)this.explorer.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (on) {
                    LexicalSortingAction.this.explorer.getViewer().setSorter((ViewerSorter)LexicalSortingAction.this.sorter);
                } else {
                    LexicalSortingAction.this.explorer.getViewer().setSorter(null);
                }
            }
        });
        if (store) {
            AngularUIPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
        }
    }

    class LexicalSorter
    extends ViewerSorter {
        LexicalSorter() {
        }

        public int category(Object element) {
            if (element instanceof BaseModel) {
                switch (((BaseModel)element).getType()) {
                    case ScriptsFolder: 
                    case Module: {
                        return 0;
                    }
                    case AngularElement: {
                        AngularElement angularElement = (AngularElement)element;
                        switch (angularElement.getAngularType()) {
                            case controller: {
                                return 5;
                            }
                            case directive: {
                                return 6;
                            }
                            case filter: {
                                return 7;
                            }
                            case factory: {
                                return 8;
                            }
                            case provider: {
                                return 9;
                            }
                            case service: {
                                return 10;
                            }
                        }
                        return 11;
                    }
                }
                return 1;
            }
            return 12;
        }
    }
}

