/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.autoedit;

import org.eclipse.angularjs.internal.ui.AngularUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.text.StructuredAutoEditStrategy;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class StructuredAutoEditStrategyAngular
extends StructuredAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.supportsSmartInsert(document)) {
            return;
        }
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && command.text != null) {
                this.smartInsertCloseEndEL(command, document, model);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void smartInsertCloseEndEL(DocumentCommand command, IDocument document, IStructuredModel model) {
        try {
            if (this.isPreferenceEnabled("completeEndEL") && command.text.equals("{") && document.getLength() > 0 && document.getChar(command.offset - 1) == '{') {
                IDOMNode cfr_ignored_0 = (IDOMNode)model.getIndexedRegion(command.offset - 1);
                command.text = String.valueOf(command.text) + "}}";
                command.shiftsCaret = false;
                command.caretOffset = command.offset + 1;
                command.doit = false;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isPreferenceEnabled(String key) {
        return key != null && AngularUIPlugin.getDefault().getPreferenceStore().getBoolean(key);
    }
}

