/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.configurationmetadata.ConfigurationMetadataSource;

public class PropertyInfo {
    private final String id;
    private final String type;
    private final String name;
    private final Object defaultValue;
    private final String description;
    private List<PropertySource> sources;

    public PropertyInfo(String id, String type, String name, Object defaultValue, String description, List<PropertySource> sources) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        this.sources = sources;
    }

    public PropertyInfo(ConfigurationMetadataProperty prop) {
        this(prop.getId(), prop.getType(), prop.getName(), prop.getDefaultValue(), prop.getDescription(), null);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PropertySource> getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "PropertyInfo(" + this.getId() + ")";
    }

    public void addSource(ConfigurationMetadataSource source) {
        if (this.sources == null) {
            this.sources = new ArrayList<PropertySource>();
        }
        this.sources.add(new PropertySource(source));
    }

    public PropertyInfo withId(String alias) {
        if (alias.equals(this.id)) {
            return this;
        }
        return new PropertyInfo(alias, this.type, this.name, this.defaultValue, this.description, this.sources);
    }

    public static class PropertySource {
        private final String sourceType;
        private final String sourceMethod;

        public PropertySource(ConfigurationMetadataSource source) {
            String st = source.getSourceType();
            this.sourceType = st != null ? st : source.getType();
            this.sourceMethod = source.getSourceMethod();
        }

        public String toString() {
            return String.valueOf(this.sourceType) + "::" + this.sourceMethod;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getSourceMethod() {
            return this.sourceMethod;
        }
    }
}

