/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.configurationmetadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.json.JSONException;
import org.springframework.configurationmetadata.ConfigurationMetadataItem;
import org.springframework.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.configurationmetadata.ConfigurationMetadataSource;
import org.springframework.configurationmetadata.JsonReader;
import org.springframework.configurationmetadata.RawConfigurationMetadata;
import org.springframework.configurationmetadata.SimpleConfigurationMetadataRepository;

public class ConfigurationMetadataRepositoryJsonLoader {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private JsonReader reader = new JsonReader();

    public ConfigurationMetadataRepository loadAll(Collection<InputStream> resources) throws IOException {
        return this.loadAll(resources, UTF_8);
    }

    public ConfigurationMetadataRepository loadAll(Collection<InputStream> resources, Charset charset) throws IOException {
        if (resources == null) {
            throw new IllegalArgumentException("Resources must not be null.");
        }
        if (resources.size() == 1) {
            return this.load(resources.iterator().next(), charset);
        }
        SimpleConfigurationMetadataRepository repository = new SimpleConfigurationMetadataRepository();
        for (InputStream resource : resources) {
            SimpleConfigurationMetadataRepository repo = this.load(resource, charset);
            repository.include(repo);
        }
        return repository;
    }

    private SimpleConfigurationMetadataRepository load(InputStream stream, Charset charset) throws IOException {
        try {
            RawConfigurationMetadata metadata = this.reader.read(stream, charset);
            return this.create(metadata);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read configuration metadata", e);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid configuration metadata document", e);
        }
    }

    private SimpleConfigurationMetadataRepository create(RawConfigurationMetadata metadata) {
        SimpleConfigurationMetadataRepository repository = new SimpleConfigurationMetadataRepository();
        repository.add(metadata.getSources());
        for (ConfigurationMetadataItem item : metadata.getItems()) {
            ConfigurationMetadataSource source = null;
            String sourceType = item.getSourceType();
            if (sourceType != null) {
                source = metadata.getSource(sourceType);
            }
            repository.add(item, source);
        }
        return repository;
    }
}

