/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.util.StringUtils;

public class TransitionValidationRule
implements IValidationRule<StateTransition, WebflowValidationContext> {
    private static final String EXPRESSION_PREFIX = "${";
    private static final String SPEL_EXPRESSION_PREFIX = "#{";
    private static final String EXPRESSION_SUFFIX = "}";

    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof StateTransition && context instanceof WebflowValidationContext;
    }

    public void validate(StateTransition state, WebflowValidationContext context, IProgressMonitor monitor) {
        if (context.isVersion1()) {
            if (!StringUtils.hasText((String)state.getToStateId())) {
                context.error(state, "NO_TO_ATTRIBUTE", "Element 'transition' requires 'to' attribute", new ValidationProblemAttribute[0]);
            }
            if (!(state.getToState() != null || state.getToStateId() == null || (state.getToStateId().startsWith(EXPRESSION_PREFIX) || state.getToStateId().startsWith(SPEL_EXPRESSION_PREFIX)) && state.getToStateId().endsWith(EXPRESSION_SUFFIX))) {
                context.error(state, "NO_VALID_TO_ATTRIBUTE", MessageUtils.format((String)"Element 'transition' references a non-exiting state \"{0}\"", (Object)state.getToStateId()), new ValidationProblemAttribute[0]);
            }
        } else if (!(state.getToState() != null || state.getToStateId() == null || (state.getToStateId().startsWith(EXPRESSION_PREFIX) || state.getToStateId().startsWith(SPEL_EXPRESSION_PREFIX)) && state.getToStateId().endsWith(EXPRESSION_SUFFIX) || context.getStateFromParentFlow(state.getToStateId(), context.getWebflowConfig()) != null)) {
            context.error(state, "NO_VALID_TO_ATTRIBUTE", MessageUtils.format((String)"Element 'transition' references a non-exiting state \"{0}\"", (Object)state.getToStateId()), new ValidationProblemAttribute[0]);
        }
    }
}

