/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.project.WebflowProjectDescription;
import org.springframework.ide.eclipse.webflow.core.internal.model.project.WebflowProjectDescriptionReader;
import org.springframework.ide.eclipse.webflow.core.internal.model.project.WebflowProjectDescriptionWriter;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModel;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class WebflowProject
extends AbstractModelElement
implements IWebflowProject {
    private final IProject project;
    private final IWebflowModel model;
    private WebflowProjectDescription description;

    public WebflowProject(IProject project, IWebflowModel model) {
        this.project = project;
        this.model = model;
    }

    @Override
    public List<IWebflowConfig> getConfigs() {
        return this.getDescription().getConfigs();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    private WebflowProjectDescription getDescription() {
        if (this.description == null) {
            this.description = WebflowProjectDescriptionReader.read(this);
        }
        return this.description;
    }

    @Override
    public void setConfigs(List<IWebflowConfig> configs) {
        WebflowProjectDescription description = this.getDescription();
        description.setConfigs(configs);
        WebflowProjectDescriptionWriter.write(this.project, description);
        this.model.fireModelChangedEvent(this);
    }

    @Override
    public IWebflowConfig getConfig(IFile file) {
        List<IWebflowConfig> configs = this.getDescription().getConfigs();
        if (configs != null) {
            for (IWebflowConfig config : configs) {
                if (!config.getResource().equals((Object)file)) continue;
                return config;
            }
        }
        return null;
    }

    @Override
    public String getElementName() {
        return this.project.getName();
    }

    @Override
    public int getElementType() {
        return 2;
    }

    public IModelElement[] getElementChildren() {
        HashSet<IWebflowConfig> children = new HashSet<IWebflowConfig>();
        children.addAll(this.getConfigs());
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public Object getAdapter(Class adapter) {
        return null;
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IWebflowConfig project : this.getConfigs()) {
                project.accept(visitor, monitor);
            }
        }
    }

    @Override
    public IModelElement getElementParent() {
        return this.model;
    }

    @Override
    public IResource getElementResource() {
        return this.project;
    }

    @Override
    public boolean isElementArchived() {
        return false;
    }

    @Override
    public IWebflowConfig getConfig(String flowId) {
        for (IWebflowConfig config : this.getConfigs()) {
            if (!config.getName().equals(flowId)) continue;
            return config;
        }
        return null;
    }

    public void saveDescription() {
        WebflowProjectDescription description = this.getDescription();
        WebflowProjectDescriptionWriter.write(this.project, description);
    }

    @Override
    public boolean isUpdatable() {
        IFile file = this.project.getProject().getFile((IPath)new Path(".springWebflow"));
        return !file.isReadOnly();
    }
}

