/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractActionElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractTransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionState
extends AbstractTransitionableFrom
implements IActionState,
ICloneableModelElement<IActionState> {
    private List<IActionElement> actions = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.actions = new ArrayList<IActionElement>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                AbstractActionElement action;
                IDOMNode child = (IDOMNode)children.item(i);
                if ("action".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("render".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("bean-action".equals(child.getLocalName())) {
                    action = new BeanAction();
                    ((BeanAction)action).init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("evaluate-action".equals(child.getLocalName())) {
                    action = new EvaluateAction();
                    ((EvaluateAction)action).init(child, this);
                    ((EvaluateAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("evaluate".equals(child.getLocalName())) {
                    action = new EvaluateAction();
                    ((EvaluateAction)action).init(child, this);
                    ((EvaluateAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("set".equals(child.getLocalName())) {
                    action = new Set();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                }
                ++i;
            }
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    @Override
    public List<IActionElement> getActions() {
        return this.actions;
    }

    @Override
    public void addAction(IActionElement action) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.getNode());
            super.firePropertyChange("add_children", new Integer(this.actions.indexOf(action)), action);
        }
    }

    @Override
    public void removeAction(IActionElement action) {
        if (this.actions.contains(action)) {
            this.actions.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public void addAction(IActionElement action, int i) {
        if (!this.actions.contains(action)) {
            if (this.actions.size() > i) {
                IActionElement ref = this.actions.get(i);
                WebflowModelXmlUtils.insertBefore((Node)action.getNode(), (Node)ref.getNode());
            } else {
                WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            }
            this.actions.add(i, action);
            super.firePropertyChange("add_children", new Integer(i), action);
        }
    }

    @Override
    public void createNew(IWebflowState parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("action-state");
        this.init(node, parent);
    }

    @Override
    public IActionState cloneModelElement() {
        ActionState state = new ActionState();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(IActionState element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setId(element.getId());
            this.init(element.getNode(), this.parent);
        }
    }

    @Override
    public void removeAll() {
        for (IActionElement action : this.actions) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.actions = new ArrayList<IActionElement>();
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            if (this.getEntryActions() != null) {
                this.getEntryActions().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            for (IActionElement iActionElement : this.getActions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iActionElement.accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getExitActions() != null) {
                this.getExitActions().accept(visitor, monitor);
            }
            for (IExceptionHandler iExceptionHandler : this.getExceptionHandlers()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iExceptionHandler.accept(visitor, monitor);
            }
            for (ITransition iTransition : this.getOutputTransitions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iTransition.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.add(this.getEntryActions());
        children.addAll(this.getActions());
        children.add(this.getExitActions());
        children.addAll(this.getExceptionHandlers());
        children.addAll(this.getOutputTransitions());
        return children.toArray(new IModelElement[children.size()]);
    }
}

