/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.validation;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.quickfix.GeneratorComposition;
import org.springframework.ide.eclipse.boot.quickfix.MarkerResolutionRegistry;
import org.springframework.ide.eclipse.boot.validation.BootMarkerUtils;
import org.springframework.ide.eclipse.boot.validation.BootValidationRule;
import org.springframework.ide.eclipse.boot.validation.ClasspathMatcher;
import org.springframework.ide.eclipse.boot.validation.SpringBootValidationContext;
import org.springframework.ide.eclipse.boot.validation.SpringCompilationUnit;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

public class MissingConfigurationProcessorRule
extends BootValidationRule {
    private static final String PROBLEM_ID = "MISSING_CONFIGURATION_PROCESSOR";
    private static final MavenCoordinates DEP_CONFIGURATION_PROCESSOR = new MavenCoordinates("org.springframework.boot", "spring-boot-configuration-processor", null);
    private static final IMarkerResolutionGenerator2 QUICK_FIX = new IMarkerResolutionGenerator2(){

        public IMarkerResolution[] getResolutions(IMarker marker) {
            try {
                final ISpringBootProject project = SpringBootCore.create(BootMarkerUtils.getProject(marker));
                return new IMarkerResolution[]{new IMarkerResolution(){

                    public String getLabel() {
                        return "Add spring-boot-configuration-processor to pom.xml";
                    }

                    public void run(IMarker marker) {
                        try {
                            project.addMavenDependency(DEP_CONFIGURATION_PROCESSOR, true, true);
                            project.updateProjectConfiguration();
                        }
                        catch (Exception e) {
                            BootActivator.log(e);
                        }
                    }
                }};
            }
            catch (Exception exception) {
                return GeneratorComposition.NO_RESOLUTIONS;
            }
        }

        public boolean hasResolutions(IMarker marker) {
            try {
                IProject project = BootMarkerUtils.getProject(marker);
                if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    return true;
                }
            }
            catch (Exception e) {
                BootActivator.log(e);
            }
            return false;
        }
    };
    private static final ClasspathMatcher CLASSPATH_MATCHER;

    static {
        MarkerResolutionRegistry.DEFAULT_INSTANCE.register(PROBLEM_ID, QUICK_FIX);
        CLASSPATH_MATCHER = new ClasspathMatcher(false){

            @Override
            protected boolean doMatch(IClasspathEntry[] classpath) {
                IClasspathEntry[] iClasspathEntryArray = classpath;
                int n = classpath.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry e = iClasspathEntryArray[n2];
                    if (this.isJarNameContaining(e, "spring-boot-configuration-processor")) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof SpringCompilationUnit;
    }

    public void validate(SpringCompilationUnit cu, SpringBootValidationContext context, IProgressMonitor mon) {
        try {
            if (CLASSPATH_MATCHER.match(cu.getClasspath())) {
                ValidationVisitor visitor = new ValidationVisitor(context, cu);
                visitor.visit(cu.getCompilationUnit(), mon);
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
    }

    public static class ValidationVisitor {
        private SpringBootValidationContext context;
        private SpringCompilationUnit cu;

        public ValidationVisitor(SpringBootValidationContext context, SpringCompilationUnit cu) {
            this.context = context;
            this.cu = cu;
        }

        public void visit(ICompilationUnit compilationUnit, IProgressMonitor mon) throws Exception {
            IType[] types = compilationUnit.getAllTypes();
            mon.beginTask(compilationUnit.getElementName(), types.length);
            try {
                IType[] iTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    this.visit(t, new SubProgressMonitor(mon, 1));
                    ++n2;
                }
            }
            finally {
                mon.done();
            }
        }

        private void visit(IType t, SubProgressMonitor mon) throws Exception {
            IMethod[] methods = t.getMethods();
            mon.beginTask(t.getElementName(), 1 + methods.length);
            try {
                IAnnotation annot = t.getAnnotation("ConfigurationProperties");
                if (annot != null && annot.exists()) {
                    this.visit(annot);
                    mon.worked(1);
                }
                IMethod[] iMethodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod m = iMethodArray[n2];
                    this.visit(m, new SubProgressMonitor((IProgressMonitor)mon, 1));
                    ++n2;
                }
            }
            finally {
                mon.done();
            }
        }

        private void visit(IAnnotation annot) throws Exception {
            this.warn("When using @ConfigurationProperties it is recommended to add 'spring-boot-configuration-processor' to your classpath to generate configuration metadata", annot.getNameRange());
        }

        private void visit(IMethod m, SubProgressMonitor mon) throws Exception {
            mon.beginTask(m.getElementName(), 1);
            try {
                IAnnotation annot = m.getAnnotation("ConfigurationProperties");
                if (annot != null && annot.exists()) {
                    this.visit(annot);
                    mon.worked(1);
                }
            }
            finally {
                mon.done();
            }
        }

        void warn(String msg, ISourceRange location) {
            if (location != null) {
                this.context.warning((IResourceModelElement)this.cu, MissingConfigurationProcessorRule.PROBLEM_ID, msg, new ValidationProblemAttribute[]{new ValidationProblemAttribute("charStart", (Object)location.getOffset()), new ValidationProblemAttribute("charEnd", (Object)(location.getOffset() + location.getLength()))});
            }
        }
    }
}

