/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.BootGroovyScriptLaunchConfigurationDelegate;

public class BootGroovyScriptLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        try {
            IResource rsrc = this.getResource(selection);
            this.launch(rsrc, mode);
        }
        catch (Throwable e) {
            BootActivator.log(e);
        }
    }

    public void launch(IResource rsrc, String mode) throws CoreException {
        if (rsrc != null && rsrc.getType() == 1) {
            ILaunchConfiguration conf = this.createConfiguration((IFile)rsrc);
            DebugUITools.launch((ILaunchConfiguration)conf, (String)mode);
        }
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfiguration createConfiguration(IFile rsrc) throws CoreException {
        ILaunchConfigurationType configType = this.getConfigurationType();
        String projectName = rsrc.getProject().getName();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(String.valueOf(projectName) + " " + rsrc.getName()));
        BootGroovyScriptLaunchConfigurationDelegate.setScript(wc, rsrc);
        wc.setMappedResources(new IResource[]{rsrc});
        return wc;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.springsource.ide.eclipse.boot.groovy.script.launch");
    }

    private IResource getResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object el = ss.getFirstElement();
            if (el instanceof IResource) {
                return (IResource)el;
            }
            if (el instanceof IAdaptable) {
                return (IResource)((IAdaptable)el).getAdapter(IResource.class);
            }
        }
        return null;
    }

    public void launch(IEditorPart editor, String mode) {
        try {
            IEditorInput input = editor.getEditorInput();
            IResource rsrc = (IResource)input.getAdapter(IResource.class);
            if (rsrc != null) {
                this.launch(rsrc, mode);
            }
            System.out.println(input);
        }
        catch (Throwable e) {
            BootActivator.log(e);
        }
    }
}

