/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveSet;
import org.springsource.ide.eclipse.commons.livexp.ui.OkButtonHandler;

public class EditStartersModel
implements OkButtonHandler {
    private final ISpringBootProject project;
    public final LiveSet<SpringBootStarter> starters;

    public EditStartersModel(IProject selectedProject) throws CoreException {
        this.project = SpringBootCore.create(selectedProject);
        this.starters = new LiveSet();
        this.starters.addAll(this.project.getBootStarters());
    }

    public SpringBootStarter[] getAvailableStarters() throws CoreException {
        return this.project.getKnownStarters().toArray(new SpringBootStarter[0]);
    }

    public String getProjectName() {
        return this.project.getProject().getName();
    }

    public void performOk() {
        Job job = new Job("Modifying starters for " + this.getProjectName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    EditStartersModel.this.project.setStarters(EditStartersModel.this.starters.getValues());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    BootActivator.log(e);
                    return ExceptionUtil.status((Throwable)e);
                }
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.schedule();
    }
}

