/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.internal.configurator.IConfigurator;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springsource.ide.eclipse.commons.configurator";
    public static final String PROPERTY_CONFIGURATOR_PROCESSED = "org.springsource.ide.eclipse.commons.configurator.processed";
    public static final String PROPERTY_CONFIGURE_TARGETS = "org.springsource.ide.eclipse.commons.configurator.configuretargets";
    public static final String PROPERTY_USER_INSTALL_PATH = "org.springsource.ide.eclipse.commons.configurator.installPath";
    private static Activator plugin;
    private boolean configurationActionRegistered;

    public static Activator getDefault() {
        return plugin;
    }

    public boolean isConfigurationActionRegistered() {
        return this.configurationActionRegistered;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        new DefaultScope().getNode(PLUGIN_ID).putBoolean(PROPERTY_CONFIGURATOR_PROCESSED, false);
        try {
            IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.equinox.p2.engine.actions", "org.springsource.ide.eclipse.commons.configure");
            boolean bl = this.configurationActionRegistered = extension != null;
            if (!this.configurationActionRegistered) {
                this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Registeration of configure action failed. This may cause extension install to fail."));
            }
        }
        catch (Throwable t) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Registeration of configure action failed. This may cause extension install to fail.", t));
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static IConfigurator getConfigurator() {
        return ConfiguratorExtensionPointReader.getConfigurator();
    }

    static class ConfiguratorExtensionPointReader {
        private static final String EXTENSION_ID_CONFIGURATOR = "com.springsource.sts.ide.ui.configurator";
        private static final String ELEMENT_CONFIGURATOR = "configurator";
        private static final String ELEMENT_CLASS = "class";

        ConfiguratorExtensionPointReader() {
        }

        public static IConfigurator getConfigurator() {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_CONFIGURATOR);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurator configurator;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().compareTo(ELEMENT_CONFIGURATOR) == 0 && (configurator = ConfiguratorExtensionPointReader.readConfiguratorExtension(element)) != null) {
                        return configurator;
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }

        private static IConfigurator readConfiguratorExtension(IConfigurationElement configurationElement) {
            try {
                Object object = WorkbenchPlugin.createExtension((IConfigurationElement)configurationElement, (String)ELEMENT_CLASS);
                if (!(object instanceof IConfigurator)) {
                    StatusHandler.log((IStatus)new Status(4, Activator.PLUGIN_ID, "Could not load " + object.getClass().getCanonicalName() + " must implement " + IConfigurator.class.getCanonicalName()));
                }
                return (IConfigurator)object;
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, Activator.PLUGIN_ID, "Could not load configurator extension", (Throwable)e));
                return null;
            }
        }
    }
}

