/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.IPluginListColumn;

public class TreeViewerComposite {
    private TreeViewer viewer;
    private IPluginListColumn[] columns;
    private ColumnSortListener columnListener;
    private IPluginListColumn defaultSortColumn;

    public TreeViewerComposite(IPluginListColumn[] columns, IPluginListColumn defaultSortColumn) {
        this.defaultSortColumn = defaultSortColumn;
        this.columns = columns;
    }

    protected int getViewerConfiguration() {
        return 68354;
    }

    protected ICheckStateProvider getCheckStateProvider() {
        return null;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected int getViewerHeightHint() {
        return 200;
    }

    public void createControls(Composite parent) {
        Composite treeComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeComposite);
        GridLayoutFactory.fillDefaults().applyTo(treeComposite);
        Tree tree = new Tree(treeComposite, this.getViewerConfiguration());
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.getViewerHeightHint()).applyTo((Control)tree);
        this.viewer = new TreeViewer(tree);
        if (this.columns != null && this.columns.length > 0) {
            PixelConverter converter = new PixelConverter((Control)treeComposite);
            IPluginListColumn[] iPluginListColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginListColumn column = iPluginListColumnArray[n2];
                if (column != null) {
                    TreeColumn treeColumn = new TreeColumn(tree, 0);
                    treeColumn.setResizable(true);
                    treeColumn.setWidth(converter.convertWidthInCharsToPixels(column.getWidth()));
                    treeColumn.setText(column.getName());
                }
                ++n2;
            }
            tree.setHeaderVisible(true);
        }
        this.initSorting();
        this.initListeners();
        this.viewer.refresh();
    }

    protected void initSorting() {
        TreeColumn sortColumn = this.getDefaultSortColumn();
        Tree tree = this.viewer.getTree();
        if (sortColumn != null) {
            tree.setSortColumn(sortColumn);
            tree.setSortDirection(128);
        }
    }

    protected TreeColumn getDefaultSortColumn() {
        if (this.defaultSortColumn == null) {
            return null;
        }
        String sortColumnName = this.defaultSortColumn.getName();
        if (sortColumnName == null) {
            return null;
        }
        Tree tree = this.viewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        if (columns != null) {
            TreeColumn[] treeColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                if (sortColumnName.equals(column.getText())) {
                    return column;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void initListeners() {
        TreeColumn[] columns = this.viewer.getTree().getColumns();
        if (this.columnListener != null) {
            this.removeListeners();
        }
        this.columnListener = new ColumnSortListener();
        TreeColumn[] treeColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.addSelectionListener((SelectionListener)this.columnListener);
            ++n2;
        }
    }

    public void dispose() {
        this.removeListeners();
    }

    protected void removeListeners() {
        if (this.columnListener != null) {
            TreeColumn[] columns;
            TreeColumn[] treeColumnArray = columns = this.viewer.getTree().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.removeSelectionListener((SelectionListener)this.columnListener);
                ++n2;
            }
        }
    }

    protected class ColumnSortListener
    extends SelectionAdapter {
        protected ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof TreeColumn) {
                TreeColumn selectedColumn = (TreeColumn)e.widget;
                Tree tree = TreeViewerComposite.this.viewer.getTree();
                TreeColumn currentSortColumn = tree.getSortColumn();
                int newDirection = 128;
                if (currentSortColumn != selectedColumn) {
                    tree.setSortColumn(selectedColumn);
                } else {
                    newDirection = tree.getSortDirection() == 128 ? 1024 : 128;
                }
                tree.setSortDirection(newDirection);
                TreeViewerComposite.this.viewer.refresh();
            }
        }
    }
}

