/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.JavaParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.java.FrameworksJavaUtils;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist.IJavaContentAssistHandler;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist.JavaProjectPackageCompletionProcessor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IProjectSelectionChangeListener;

public class JavaContentAssistUIAdapter
implements IProjectSelectionChangeListener {
    private IJavaContentAssistHandler javaContentAssistHandler;
    private IJavaProject javaProject;
    private JavaParameterDescriptor javaParameter;
    private IContentAssistProcessor processor;

    public JavaContentAssistUIAdapter(JavaParameterDescriptor javaParameter) {
        Assert.isLegal((javaParameter != null ? 1 : 0) != 0);
        this.javaParameter = javaParameter;
    }

    public static boolean isNotifierValid(IJavaContentAssistHandler adapt) {
        return adapt != null && adapt.getShell() != null && adapt.getJavaTextControl() != null;
    }

    private static int adaptToJavaSearchType(int type) {
        switch (type) {
            case 4: {
                return 6;
            }
            case 8: {
                return 5;
            }
            case 16: {
                return 2;
            }
        }
        return -1;
    }

    protected void applyContentAssist(Text text) {
        this.processor = this.createContentAssistProcessor();
        if (this.processor != null) {
            ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.processor);
            this.reconfigureContentAssistProcessor();
        }
    }

    public void adapt(IJavaContentAssistHandler handler) {
        this.javaContentAssistHandler = handler;
        Assert.isLegal((boolean)JavaContentAssistUIAdapter.isNotifierValid(handler));
        Button browse = handler.getBrowseButtonControl();
        final Text text = handler.getJavaTextControl();
        this.applyContentAssist(text);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaContentAssistUIAdapter.this.notifyTextSet(text.getText());
            }
        });
        if (browse != null) {
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JavaContentAssistUIAdapter.this.browseButtonPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    JavaContentAssistUIAdapter.this.browseButtonPressed();
                }
            });
        }
    }

    protected void browseButtonPressed() {
        if (this.javaProject == null || this.javaParameter == null) {
            return;
        }
        int type = this.javaParameter.getJavaElementType();
        BrowseButtonHandler browseHandler = null;
        switch (type) {
            case 4: 
            case 8: {
                browseHandler = new TypeBrowseButtonHandler(this.javaContentAssistHandler, this.javaParameter, this.javaProject);
                break;
            }
            case 16: {
                browseHandler = new PackageBrowseButtonHandler(this.javaContentAssistHandler, this.javaParameter, this.javaProject);
            }
        }
        if (browseHandler != null) {
            browseHandler.browseButtonPressed();
        }
    }

    protected void notifyTextSet(String text) {
        this.javaContentAssistHandler.handleJavaTypeSelection(text);
    }

    protected IContentAssistProcessor createContentAssistProcessor() {
        if (this.javaParameter == null) {
            return null;
        }
        int type = this.javaParameter.getJavaElementType();
        switch (type) {
            case 4: 
            case 8: {
                return new JavaTypeCompletionProcessor(false, false, true);
            }
            case 16: {
                return new JavaProjectPackageCompletionProcessor();
            }
        }
        return null;
    }

    protected void reconfigureContentAssistProcessor() {
        if (this.javaProject == null) {
            return;
        }
        if (this.processor instanceof JavaTypeCompletionProcessor) {
            JavaTypeCompletionProcessor javaProcessor = (JavaTypeCompletionProcessor)this.processor;
            IPackageFragmentRoot[] roots = FrameworksJavaUtils.getFirstEncounteredSourcePackageFragmentRoots((IJavaProject)this.javaProject);
            if (roots != null) {
                IPackageFragment fragment = null;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    try {
                        IJavaElement[] members = root.getChildren();
                        if (members != null) {
                            IJavaElement[] iJavaElementArray = members;
                            int n3 = members.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IPackageFragment frag;
                                IJavaElement element = iJavaElementArray[n4];
                                if (element instanceof IPackageFragment && (frag = (IPackageFragment)element).isDefaultPackage()) {
                                    fragment = frag;
                                    break;
                                }
                                ++n4;
                            }
                        }
                        if (fragment != null) {
                            break;
                        }
                    }
                    catch (JavaModelException e) {
                        FrameworkCoreActivator.logError((String)e.getLocalizedMessage(), (Throwable)e);
                    }
                    ++n2;
                }
                if (fragment != null) {
                    final IPackageFragment packFrag = fragment;
                    javaProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

                        public StubTypeContext getStubTypeContext() {
                            return JavaContentAssistUIAdapter.this.getContentAssistTypeContext(packFrag, "$$__$$");
                        }
                    });
                }
            }
        } else if (this.processor instanceof JavaProjectPackageCompletionProcessor) {
            ((JavaProjectPackageCompletionProcessor)this.processor).setProject(this.javaProject);
        }
    }

    protected StubTypeContext getContentAssistTypeContext(IPackageFragment frag, String typeName) {
        if (this.javaParameter == null) {
            return null;
        }
        int type = this.javaParameter.getJavaElementType();
        switch (type) {
            case 8: {
                return TypeContextChecker.createSuperClassStubTypeContext((String)typeName, null, (IPackageFragment)frag);
            }
            case 4: {
                return TypeContextChecker.createSuperInterfaceStubTypeContext((String)typeName, null, (IPackageFragment)frag);
            }
        }
        return null;
    }

    @Override
    public void projectSelectionChanged(IProject project) {
        if (project == null) {
            this.javaProject = null;
            return;
        }
        this.javaProject = JavaCore.create((IProject)project);
        this.reconfigureContentAssistProcessor();
    }

    public static abstract class BrowseButtonHandler {
        private IJavaContentAssistHandler handler;
        private JavaParameterDescriptor descriptor;
        private IJavaProject project;

        public BrowseButtonHandler(IJavaContentAssistHandler handler, JavaParameterDescriptor descriptor, IJavaProject project) {
            this.handler = handler;
            this.descriptor = descriptor;
            this.project = project;
        }

        protected IJavaContentAssistHandler getHandler() {
            return this.handler;
        }

        protected JavaParameterDescriptor getJavaParameterDescriptor() {
            return this.descriptor;
        }

        protected IJavaProject getJavaProject() {
            return this.project;
        }

        protected void setValueInTextControl(String value) {
            Text text = this.getHandler().getJavaTextControl();
            if (text == null || text.isDisposed()) {
                return;
            }
            text.setText(value);
        }

        protected void setValue(String value) {
            this.setValueInTextControl(value);
            this.getHandler().handleJavaTypeSelection(value);
        }

        public abstract void browseButtonPressed();
    }

    public static class PackageBrowseButtonHandler
    extends BrowseButtonHandler {
        public PackageBrowseButtonHandler(IJavaContentAssistHandler handler, JavaParameterDescriptor descriptor, IJavaProject project) {
            super(handler, descriptor, project);
        }

        @Override
        public void browseButtonPressed() {
            Object[] projectFragments = this.getPackageFragments();
            if (projectFragments == null) {
                return;
            }
            Shell shell = this.getHandler().getShell();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
            dialog.setIgnoreCase(false);
            dialog.setTitle(this.getJavaParameterDescriptor().getName());
            dialog.setMessage("Select a source package");
            dialog.setEmptyListMessage("No source packages to select in given project");
            dialog.setElements(projectFragments);
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                String dialogValue = ((IPackageFragment)dialog.getFirstResult()).getElementName();
                this.setValue(dialogValue);
            }
        }

        protected IPackageFragment[] getPackageFragments() {
            SearchPattern searchPattern;
            IPackageFragmentRoot[] roots;
            try {
                roots = this.getJavaProject().getAllPackageFragmentRoots();
                if (roots == null) {
                    return null;
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
            Text textControl = this.getHandler().getJavaTextControl();
            String pattern = textControl != null ? textControl.getText() : null;
            SearchPattern searchPattern2 = searchPattern = pattern != null ? new SearchPattern() : null;
            if (searchPattern != null) {
                searchPattern.setPattern(pattern);
            }
            ArrayList<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                try {
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    if (entry.getEntryKind() == 3) {
                        IJavaElement[] children;
                        IJavaElement[] iJavaElementArray = children = root.getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaElement child = iJavaElementArray[n4];
                            if (child instanceof IPackageFragment) {
                                String name = ((IPackageFragment)child).getElementName();
                                if (searchPattern == null || searchPattern.matches(name)) {
                                    packageFragments.add((IPackageFragment)child);
                                }
                            }
                            ++n4;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
                ++n2;
            }
            return packageFragments.toArray(new IPackageFragment[packageFragments.size()]);
        }
    }

    public static class TypeBrowseButtonHandler
    extends BrowseButtonHandler {
        private static final String TITLE = "Select a type";

        public TypeBrowseButtonHandler(IJavaContentAssistHandler handler, JavaParameterDescriptor descriptor, IJavaProject project) {
            super(handler, descriptor, project);
        }

        @Override
        public void browseButtonPressed() {
            IType type;
            Text textControl = this.getHandler().getJavaTextControl();
            String pattern = textControl != null && !textControl.isDisposed() ? textControl.getText() : null;
            Shell shell = this.getHandler().getShell();
            int javaSearchType = JavaContentAssistUIAdapter.adaptToJavaSearchType(this.getJavaParameterDescriptor().getJavaElementType());
            if (javaSearchType == -1) {
                return;
            }
            IJavaElement[] elements = new IJavaElement[]{this.getJavaProject()};
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(shell, false, null, scope, javaSearchType);
            dialog.setTitle(this.getJavaParameterDescriptor().getName());
            dialog.setMessage(TITLE);
            dialog.setInitialPattern(pattern);
            if (dialog.open() == 0 && (type = (IType)dialog.getFirstResult()) != null) {
                String qualifiedName = type.getFullyQualifiedName();
                this.setValue(qualifiedName);
            }
        }
    }
}

