/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.springframework.ide.eclipse.webflow.core.internal.model.Attribute;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ModelTableLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesContentProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertyEditorDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.TableCellModifier;

public class PropertiesComposite {
    private IAttributeEnabled state;
    private Button removeButton;
    private Button addButton;
    private Button editButton;
    private TableViewer configsViewer;
    private IDialogValidator validator;
    private Shell parentShell;

    public PropertiesComposite(IDialogValidator validator, TabItem item, Shell parentShell, IAttributeEnabled state) {
        this.state = state;
        item.setText("Attributes");
        item.setToolTipText("Define element attributes");
        item.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.properties_obj.gif"));
        this.parentShell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Group groupPropertyType = new Group(parent, 0);
        GridLayout layoutPropMap = new GridLayout();
        layoutPropMap.marginWidth = 3;
        layoutPropMap.marginHeight = 3;
        groupPropertyType.setLayout((Layout)layoutPropMap);
        groupPropertyType.setText(" Attributes ");
        groupPropertyType.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite((Composite)groupPropertyType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        data.heightHint = 150;
        configsTable.setLayoutData((Object)data);
        TableColumn columnName = new TableColumn(configsTable, 0);
        columnName.setText("Name");
        columnName.setWidth(150);
        TableColumn columnValue = new TableColumn(configsTable, 0);
        columnValue.setText("Value");
        columnValue.setWidth(120);
        TableColumn columnType = new TableColumn(configsTable, 0);
        columnType.setText("Type");
        columnType.setWidth(80);
        configsTable.setHeaderVisible(true);
        this.configsViewer = new TableViewer(configsTable);
        String[] columnNames = new String[]{"Name", "Value", "Type"};
        this.configsViewer.setColumnProperties(columnNames);
        this.configsViewer.setContentProvider((IContentProvider)new PropertiesContentProvider(this.state, this.configsViewer));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ModelTableLabelProvider());
        this.configsViewer.setCellModifier((ICellModifier)new TableCellModifier());
        this.configsViewer.setInput((Object)this.state);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesComposite.this.handleTableSelectionChanged();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText("Add");
        GridData data1 = new GridData(256);
        data1.widthHint = 40;
        this.addButton.setLayoutData((Object)data1);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Attribute property = new Attribute();
                property.createNew((IWebflowModelElement)PropertiesComposite.this.state);
                PropertyEditorDialog dialog = new PropertyEditorDialog(PropertiesComposite.this.parentShell, (IAttribute)property);
                if (dialog.open() == 0) {
                    PropertiesComposite.this.state.addAttribute((IAttribute)property);
                    PropertiesComposite.this.configsViewer.refresh(true);
                }
            }
        });
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setText("Edit");
        data1 = new GridData(256);
        data1.widthHint = 40;
        this.editButton.setLayoutData((Object)data1);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PropertiesComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IAttribute) {
                    PropertyEditorDialog dialog = new PropertyEditorDialog(PropertiesComposite.this.parentShell, (IAttribute)selection.getFirstElement());
                    dialog.open();
                    PropertiesComposite.this.configsViewer.refresh(true);
                }
            }
        });
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("Delete");
        GridData data2 = new GridData(256);
        data1.widthHint = 40;
        this.removeButton.setLayoutData((Object)data2);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PropertiesComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IAttribute) {
                    PropertiesComposite.this.state.removeAttribute((IAttribute)selection.getFirstElement());
                }
            }
        });
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        return groupPropertyType;
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }
}

