/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.ui.IEditorPart;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditor;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditorInput;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTransitionPart;

public class OpenConfigFileAction
extends EditorPartAction {
    public static final String OPEN_FILE_REQUEST = "Open_config";
    public static final String OPEN_FILE = "Open_config";

    public OpenConfigFileAction(IEditorPart editor) {
        super(editor);
    }

    protected void init() {
        this.setId("Open_config");
        this.setText("Open Config File");
        this.setToolTipText("Open element in config file");
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public boolean isEnabled() {
        EditPart part = this.getFirstSelectedEditPart();
        return part instanceof AbstractStatePart || part instanceof StateTransitionPart;
    }

    public void run() {
        Object flowModelElement = this.getFirstSelectedEditPart().getModel();
        if (flowModelElement instanceof IWebflowModelElement) {
            IWebflowModelElement element = (IWebflowModelElement)flowModelElement;
            WebflowEditorInput input = WebflowUtils.getActiveFlowEditorInput();
            IFile file = input.getFile();
            if (file != null && file.exists()) {
                SpringUIUtils.openInEditor((IFile)file, (int)input.getElementStartLine(element.getNode()));
            }
        }
    }

    protected EditPart getFirstSelectedEditPart() {
        GraphicalViewer viewer = ((WebflowEditor)this.getWorkbenchPart()).getGraphViewer();
        List list = viewer.getSelectedEditParts();
        if (!list.isEmpty()) {
            return (EditPart)list.get(0);
        }
        return null;
    }
}

