/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.theplugin.commons.crucible.api.model.CustomField;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldBean;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.Review;
import com.atlassian.theplugin.commons.crucible.api.model.User;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Comment {
    private PermId permId;
    private String message = null;
    private boolean draft = false;
    private boolean deleted = false;
    private boolean defectRaised = false;
    private boolean defectApproved = false;
    private User author = null;
    private Date createDate = new Date();
    private ReadState readState;
    private List<Comment> replies = new ArrayList<Comment>();
    private boolean isReply = false;
    private final Map<String, CustomField> customFields = new HashMap<String, CustomField>();
    private static final int HASH_INT = 31;
    private final Review review;
    @Nullable
    private final Comment parentComment;

    public Comment(Review review, @Nullable Comment parentComment) {
        this.review = review;
        this.parentComment = parentComment;
    }

    public Comment(Comment bean) {
        this.review = bean.getReview();
        this.parentComment = bean.parentComment;
        this.setPermId(bean.getPermId());
        this.setMessage(bean.getMessage());
        this.setDraft(bean.isDraft());
        this.setCreateDate(bean.getCreateDate());
        this.setDefectApproved(bean.isDefectApproved());
        this.setDefectRaised(bean.isDefectRaised());
        this.setDeleted(bean.isDeleted());
        this.setAuthor(bean.getAuthor());
        this.setAuthor(bean.getAuthor());
        this.setReply(bean.isReply());
        this.setReadState(bean.getReadState());
        if (bean.getCustomFields() != null) {
            for (Map.Entry entry : bean.getCustomFields().entrySet()) {
                this.getCustomFields().put((String)entry.getKey(), new CustomFieldBean((CustomField)entry.getValue()));
            }
        }
        if (bean.getReplies() != null) {
            for (Comment comment : bean.getReplies()) {
                this.replies.add(this.createReplyBean(comment));
            }
        }
    }

    protected abstract Comment createReplyBean(Comment var1);

    @Nullable
    public Comment getParentComment() {
        return this.parentComment;
    }

    public Review getReview() {
        return this.review;
    }

    public PermId getPermId() {
        return this.permId;
    }

    public void setPermId(PermId permId) {
        this.permId = permId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDefectRaised() {
        return this.defectRaised;
    }

    public void setDefectRaised(boolean defectRaised) {
        this.defectRaised = defectRaised;
    }

    public boolean isDefectApproved() {
        return this.defectApproved;
    }

    public boolean isReply() {
        return this.isReply;
    }

    public void setReply(boolean reply) {
        this.isReply = reply;
    }

    public void setReplies(List<Comment> replies) {
        this.replies = replies == null ? new ArrayList<Comment>() : replies;
    }

    public void addReply(Comment comment) {
        this.replies.add(comment);
    }

    public boolean removeReply(@Nullable Comment reply) {
        return this.replies.remove(reply);
    }

    public List<Comment> getReplies() {
        return this.replies;
    }

    public void setDefectApproved(boolean defectApproved) {
        this.defectApproved = defectApproved;
    }

    public User getAuthor() {
        return this.author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public Date getCreateDate() {
        return new Date(this.createDate.getTime());
    }

    public void setCreateDate(Date createDate) {
        if (createDate != null) {
            this.createDate = new Date(createDate.getTime());
        }
    }

    public Map<String, CustomField> getCustomFields() {
        return this.customFields;
    }

    public ReadState getReadState() {
        return this.readState;
    }

    public void setReadState(ReadState readState) {
        this.readState = readState;
    }

    public String toString() {
        return this.getMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Comment that = (Comment)o;
        if (!MiscUtil.isEqual(this.review.getPermId(), that.review.getPermId())) {
            return false;
        }
        if (!MiscUtil.isEqual(this.parentComment, that.parentComment)) {
            return false;
        }
        if (this.defectApproved != that.defectApproved) {
            return false;
        }
        if (this.defectRaised != that.defectRaised) {
            return false;
        }
        if (this.deleted != that.deleted) {
            return false;
        }
        if (this.draft != that.draft) {
            return false;
        }
        if (this.isReply != that.isReply) {
            return false;
        }
        if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
            return false;
        }
        if (this.createDate != null ? !this.createDate.equals(that.createDate) : that.createDate != null) {
            return false;
        }
        if (this.customFields != null ? !this.customFields.equals(that.customFields) : that.customFields != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.permId != null ? !this.permId.equals(that.permId) : that.permId != null) {
            return false;
        }
        return !(this.readState != null ? !this.readState.equals((Object)that.readState) : that.readState != null);
    }

    public int hashCode() {
        int result = this.permId != null ? this.permId.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.draft ? 1 : 0);
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + (this.defectRaised ? 1 : 0);
        result = 31 * result + (this.defectApproved ? 1 : 0);
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 31 * result + (this.createDate != null ? this.createDate.hashCode() : 0);
        result = 31 * result + (this.isReply ? 1 : 0);
        result = 31 * result + (this.customFields != null ? this.customFields.hashCode() : 0);
        result = 31 * result + (this.readState != null ? this.readState.ordinal() : 0);
        return result;
    }

    public int getNumReplies() {
        int res = this.replies.size();
        for (Comment reply : this.replies) {
            res += reply.getNumReplies();
        }
        return res;
    }

    public int getNumberOfUnreadReplies() {
        int counter = 0;
        for (Comment reply : this.replies) {
            if (reply.isEffectivelyUnread()) {
                ++counter;
            }
            counter += reply.getNumberOfUnreadReplies();
        }
        return counter;
    }

    public int getNumberOfDraftReplies() {
        int counter = 0;
        for (Comment reply : this.replies) {
            if (reply.isDraft()) {
                ++counter;
            }
            counter += reply.getNumberOfDraftReplies();
        }
        return counter;
    }

    public boolean isEffectivelyUnread() {
        return this.getReadState() == ReadState.UNREAD || this.getReadState() == ReadState.LEAVE_UNREAD;
    }

    public boolean hasDraftParents() {
        if (this.parentComment == null) {
            return false;
        }
        return this.parentComment.isDraft() || this.parentComment.hasDraftParents();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReadState {
        UNKNOWN("Unknown"),
        READ("Read"),
        UNREAD("Not read"),
        LEAVE_UNREAD("Leave unread");

        private final String name;

        private ReadState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

