/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg.xstream;

import com.atlassian.theplugin.commons.cfg.PrivateConfigurationDao;
import com.atlassian.theplugin.commons.cfg.PrivateProjectConfiguration;
import com.atlassian.theplugin.commons.cfg.PrivateServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.ProjectConfiguration;
import com.atlassian.theplugin.commons.cfg.ProjectConfigurationDao;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerCfgFactoryException;
import com.atlassian.theplugin.commons.cfg.SharedServerList;
import com.atlassian.theplugin.commons.cfg.xstream.HomeDirPrivateConfigurationDao;
import com.atlassian.theplugin.commons.cfg.xstream.JDomXStreamUtil;
import com.atlassian.theplugin.commons.cfg.xstream.UserSharedConfigurationDao;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDomProjectConfigurationDao
implements ProjectConfigurationDao {
    private final Element publicElement;
    private final PrivateConfigurationDao privateConfigurationDao;
    private final UserSharedConfigurationDao sharedCfg;

    public JDomProjectConfigurationDao(Element element, @NotNull PrivateConfigurationDao privateConfigurationDao, @NotNull UserSharedConfigurationDao userSharedCfg) {
        if (element == null) {
            throw new IllegalArgumentException(String.valueOf(Element.class.getSimpleName()) + " cannot be null");
        }
        if (privateConfigurationDao == null) {
            throw new IllegalArgumentException(String.valueOf(PrivateConfigurationDao.class.getSimpleName()) + " cannot be null");
        }
        this.publicElement = element;
        this.privateConfigurationDao = privateConfigurationDao;
        this.sharedCfg = userSharedCfg;
    }

    @Override
    public ProjectConfiguration load() throws ServerCfgFactoryException {
        PrivateProjectConfiguration ppc = new PrivateProjectConfiguration();
        ProjectConfiguration res = this.load(this.publicElement, ProjectConfiguration.class);
        SharedServerList sharedServers = this.sharedCfg.load();
        if (sharedServers != null) {
            ArrayList<ServerCfg> serversToAdd = new ArrayList<ServerCfg>();
            if (res.getServers().size() > 0) {
                for (ServerCfg sharedServer : sharedServers) {
                    if (res.getServerCfg(sharedServer.getServerId()) != null) continue;
                    serversToAdd.add(sharedServer);
                }
            } else {
                serversToAdd.addAll(sharedServers);
            }
            res.getServers().addAll(serversToAdd);
        }
        for (ServerCfg serverCfg : res.getServers()) {
            try {
                PrivateServerCfgInfo privateServerCfgInfo;
                if (serverCfg.isShared() || (privateServerCfgInfo = this.privateConfigurationDao.load(serverCfg.getServerId())) == null) continue;
                ppc.add(privateServerCfgInfo);
            }
            catch (ServerCfgFactoryException serverCfgFactoryException) {}
        }
        return this.merge(res, ppc);
    }

    public PrivateProjectConfiguration loadOldPrivateConfiguration(@NotNull Element privateElement) throws ServerCfgFactoryException {
        return this.load(privateElement, PrivateProjectConfiguration.class);
    }

    private <T> T load(Element rootElement, Class<T> clazz) throws ServerCfgFactoryException {
        int childCount = rootElement.getChildren().size();
        if (childCount != 1) {
            throw new ServerCfgFactoryException("Cannot travers JDom tree. Exactly one child node expected, but found [" + childCount + "]");
        }
        JDomReader reader = new JDomReader((Element)rootElement.getChildren().get(0));
        XStream xStream = JDomXStreamUtil.getProjectJDomXStream(false);
        try {
            return clazz.cast(xStream.unmarshal((HierarchicalStreamReader)reader));
        }
        catch (ClassCastException e) {
            throw new ServerCfgFactoryException("Cannot load " + clazz.getSimpleName() + " due to ClassCastException: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ServerCfgFactoryException("Cannot load " + clazz.getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    private ProjectConfiguration merge(ProjectConfiguration projectConfiguration, PrivateProjectConfiguration privateProjectConfiguration) {
        for (ServerCfg serverCfg : projectConfiguration.getServers()) {
            if (serverCfg.isShared()) continue;
            PrivateServerCfgInfo psci = privateProjectConfiguration.getPrivateServerCfgInfo(serverCfg.getServerId());
            serverCfg.mergePrivateConfiguration(psci);
        }
        return projectConfiguration;
    }

    @Override
    public void save(ProjectConfiguration projectConfiguration) {
        ArrayList<ServerCfg> privateServers = new ArrayList<ServerCfg>();
        SharedServerList gList = new SharedServerList();
        for (ServerCfg server : projectConfiguration.getServers()) {
            if (server.isShared()) {
                gList.add(server);
                if (!(this.privateConfigurationDao instanceof HomeDirPrivateConfigurationDao)) continue;
                ((HomeDirPrivateConfigurationDao)this.privateConfigurationDao).deleteFile(server);
                continue;
            }
            try {
                this.privateConfigurationDao.save(server.createPrivateProjectConfiguration());
                privateServers.add(server);
            }
            catch (ServerCfgFactoryException serverCfgFactoryException) {
                LoggerImpl.getInstance().error("Cannot write private cfg file for server Uuid = " + server.getServerId().getId());
            }
        }
        ProjectConfiguration configurationToSave = new ProjectConfiguration(projectConfiguration);
        configurationToSave.getServers().clear();
        configurationToSave.getServers().addAll(privateServers);
        this.save(configurationToSave, this.publicElement);
        try {
            this.sharedCfg.save(gList, projectConfiguration.getServers());
        }
        catch (ServerCfgFactoryException e) {
            LoggerImpl.getInstance().error("Cannot write private shared config file ", e);
        }
    }

    void save(Object object, Element rootElement) {
        if (object == null) {
            throw new NullPointerException("Serialized object cannot be null");
        }
        JDomWriter writer = new JDomWriter(rootElement);
        XStream xStream = JDomXStreamUtil.getProjectJDomXStream(false);
        xStream.marshal(object, (HierarchicalStreamWriter)writer);
    }

    static PrivateServerCfgInfo createPrivateProjectConfiguration(ServerCfg serverCfg) {
        return serverCfg.createPrivateProjectConfiguration();
    }
}

