/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg.xstream;

import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerCfgFactoryException;
import com.atlassian.theplugin.commons.cfg.SharedServerList;
import com.atlassian.theplugin.commons.cfg.xstream.BasePrivateConfigurationDao;
import com.atlassian.theplugin.commons.cfg.xstream.UserSharedConfigurationDao;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeDirSharedConfigurationImpl
extends BasePrivateConfigurationDao<SharedServerList>
implements UserSharedConfigurationDao {
    private static final String GLOBAL_SERVERS_FILE_NAME = "shared-servers";

    @Override
    public synchronized void save(SharedServerList serversInfo, Collection<ServerCfg> allServers) throws ServerCfgFactoryException {
        File outputFile = null;
        try {
            outputFile = new File(HomeDirSharedConfigurationImpl.getPrivateCfgDirectorySavePath(), GLOBAL_SERVERS_FILE_NAME);
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            SharedServerList storedList = this.load();
            if (!outputFile.exists() || !outputFile.canWrite()) {
                LoggerImpl.getInstance().error("Shared configuration hasn't been saved - cannot write file " + outputFile.getAbsolutePath());
                throw new ServerCfgFactoryException("Shared configuration hasn't been saved");
            }
            Document document = storedList != null ? this.createJDom(SharedServerList.merge(serversInfo, storedList, allServers)) : this.createJDom(serversInfo);
            this.writeXmlFile(document.getRootElement(), outputFile);
        }
        catch (Exception e) {
            LoggerImpl.getInstance().error("Shared configuration hasn't been saved", e);
            ServerCfgFactoryException ex = new ServerCfgFactoryException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public SharedServerList load() throws ServerCfgFactoryException {
        File atlassianDir = HomeDirSharedConfigurationImpl.getPrivateCfgDirectorySavePath();
        if (this.isDirReady()) {
            File sharedConfigFile = new File(atlassianDir.getAbsolutePath(), GLOBAL_SERVERS_FILE_NAME);
            if (sharedConfigFile.isFile() && sharedConfigFile.canRead() && sharedConfigFile.length() > 0L) {
                Document doc;
                SAXBuilder builder = new SAXBuilder(false);
                try {
                    doc = builder.build(sharedConfigFile.toURI().toString());
                }
                catch (JDOMException e) {
                    throw new ServerCfgFactoryException("Cannot parse shared cfg file " + e.getMessage());
                }
                catch (IOException e) {
                    throw new ServerCfgFactoryException("Cannot read shared cfg file " + sharedConfigFile.getAbsolutePath() + " : " + e.getMessage());
                }
                SharedServerList globalServerInfos = null;
                if (doc != null) {
                    globalServerInfos = HomeDirSharedConfigurationImpl.loadJDom(doc.getRootElement(), SharedServerList.class, true);
                }
                return globalServerInfos;
            }
            return null;
        }
        throw new ServerCfgFactoryException("Cannot read shared configuration stored in directory [" + atlassianDir.getAbsolutePath() + "]. Directory does not exist or is not accessible");
    }

    @Override
    String getRootElementName() {
        return GLOBAL_SERVERS_FILE_NAME;
    }
}

