/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class CachedIconLoader {
    private static Map<String, Icon> icons = new HashMap<String, Icon>();
    private static Map<String, Icon> disabledIcons = new HashMap<String, Icon>();

    private CachedIconLoader() {
    }

    public static Icon getDisabledIcon(String urlString) {
        return disabledIcons.get(urlString);
    }

    private static void addDisabledIcon(String urlString, Icon icon) {
        disabledIcons.put(urlString, icon);
    }

    private static Icon generateDisabledIcon(Icon icon) {
        return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
    }

    private static void maybeGenerateDisabledIcon(String urlString, Icon icon) {
        if (disabledIcons.containsKey(urlString) || icon == null) {
            return;
        }
        CachedIconLoader.addDisabledIcon(urlString, CachedIconLoader.generateDisabledIcon(icon));
    }

    public static Icon getIcon(URL url) {
        if (url != null) {
            String key = url.toString();
            if (!icons.containsKey(key)) {
                ImageIcon i = new ImageIcon(url);
                icons.put(key, i);
                CachedIconLoader.maybeGenerateDisabledIcon(key, i);
            }
            return icons.get(key);
        }
        return null;
    }

    public static Icon getIcon(String urlString) {
        if (urlString != null) {
            if (!icons.containsKey(urlString)) {
                CachedIconLoader.loadIcon(urlString);
            }
            return icons.get(urlString);
        }
        return null;
    }

    public static void loadIcon(String urlString) {
        if (urlString != null && !icons.containsKey(urlString)) {
            try {
                URL url = new URL(urlString);
                ImageIcon i = new ImageIcon(url);
                icons.put(urlString, i);
                CachedIconLoader.maybeGenerateDisabledIcon(urlString, i);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }
}

