/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class JiraTimeFormatter {
    private JiraTimeFormatter() {
    }

    public static String formatShortTimeFromJiraTimeString(String dateString, Locale locale) {
        String t;
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z (z)", locale);
        DateFormat ds = DateFormat.getDateTimeInstance(3, 3);
        if (dateString == null) {
            return "";
        }
        try {
            t = ds.format(df.parse(dateString));
        }
        catch (ParseException parseException) {
            df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", locale);
            try {
                t = ds.format(df.parse(dateString));
            }
            catch (ParseException parseException2) {
                t = "Invalid";
            }
        }
        return t;
    }

    public static String formatDateTimeFromJiraTimeString(String dateString, Locale locale) {
        String t;
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z (z)", locale);
        SimpleDateFormat ds = new SimpleDateFormat("dd/MMM/yy HH:mm");
        try {
            t = ds.format(df.parse(dateString));
        }
        catch (ParseException parseException) {
            df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", locale);
            try {
                t = ds.format(df.parse(dateString));
            }
            catch (ParseException parseException2) {
                t = "Invalid";
            }
        }
        return t;
    }

    public static String formatDateFromJiraTimeString(String dateString, Locale locale) {
        String t;
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z (z)", locale);
        SimpleDateFormat ds = new SimpleDateFormat("dd/MMM/yy", locale);
        try {
            t = ds.format(df.parse(dateString));
        }
        catch (ParseException parseException) {
            df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", locale);
            try {
                t = ds.format(df.parse(dateString));
            }
            catch (ParseException parseException2) {
                df = new SimpleDateFormat("yyyy-MM-dd", locale);
                try {
                    t = ds.format(df.parse(dateString));
                }
                catch (ParseException parseException3) {
                    t = "Invalid";
                }
            }
        }
        return t;
    }
}

