/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowConfig;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.ui.Activator;
import org.springframework.ide.eclipse.webflow.ui.wizards.LinkToBeansConfigWizardPage;
import org.springframework.ide.eclipse.webflow.ui.wizards.NewWebflowConfigFilePage;
import org.springframework.util.StringUtils;

public class NewWebflowConfigWizard
extends Wizard
implements INewWizard {
    private NewWebflowConfigFilePage mainPage;
    private LinkToBeansConfigWizardPage linkPage;
    private IStructuredSelection selection;
    private IWebflowConfig newConfig;

    public NewWebflowConfigWizard() {
        this.setDialogSettings(Activator.getDefault().getDialogSettings());
    }

    public IWebflowConfig getNewConfig() {
        return this.newConfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Create a new Spring Web Flow Definition file");
        this.setDefaultPageImageDescriptor(BeansUIImages.DESC_WIZ_CONFIG);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewWebflowConfigFilePage("webflowNewConfigPage", this.selection);
        this.linkPage = new LinkToBeansConfigWizardPage("webflowLinkConfigPage");
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.linkPage);
    }

    public boolean performFinish() {
        this.createNewConfig();
        if (this.newConfig == null) {
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)this.newConfig.getResource(), (IWorkbenchWindow)BeansUIPlugin.getActiveWorkbenchWindow());
        SpringUIUtils.openInEditor((IFile)this.newConfig.getResource(), (int)-1);
        return true;
    }

    private void createNewConfig() {
        if (!StringUtils.hasText((String)this.mainPage.getFileExtension())) {
            this.mainPage.setFileExtension("xml");
        }
        IFile file = this.mainPage.createNewFile();
        this.newConfig = new WebflowConfig(this.getProject(file));
        this.newConfig.setResource(file);
        String name = this.linkPage.getName();
        if (name != null && !"".equals(name)) {
            this.newConfig.setName(name);
        }
        this.newConfig.setBeansConfigs(this.linkPage.getBeansConfigs());
        IWebflowProject wfp = this.getProject(file);
        List configs = wfp.getConfigs();
        configs.add(this.newConfig);
        wfp.setConfigs(configs);
    }

    private IWebflowProject getProject(final IFile file) {
        IWebflowProject webflowProject;
        if (!SpringCoreUtils.isSpringProject((IResource)file)) {
            WorkspaceModifyOperation oper = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    SpringCoreUtils.addProjectNature((IProject)file.getProject(), (String)"org.springframework.ide.eclipse.core.springnature", (IProgressMonitor)monitor);
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)oper);
            }
            catch (InvocationTargetException e) {
                SpringCore.log((Throwable)e);
            }
            catch (InterruptedException e) {
                SpringCore.log((Throwable)e);
            }
        }
        if ((webflowProject = org.springframework.ide.eclipse.webflow.core.Activator.getModel().getProject(file.getProject())) != null) {
            return webflowProject;
        }
        return new WebflowProject(file.getProject(), org.springframework.ide.eclipse.webflow.core.Activator.getModel());
    }
}

