/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core;

import com.atlassian.connector.eclipse.internal.bamboo.core.TestResultExternalizer;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.TestDetails;
import com.atlassian.theplugin.commons.bamboo.TestResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxTestResultsWriter {
    private OutputStream outputStream;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeApplicationsToStream(Map<String, TestResultExternalizer.TestSuite> testResults, BambooBuild build, int failed, int success) throws IOException {
        if (this.outputStream == null) {
            IOException ioe = new IOException("OutputStream not set");
            throw ioe;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new SAXSource(new TestResultsWriter(), new TestResultsInputSource(testResults, build, failed, success)), new StreamResult(this.outputStream));
        }
        catch (TransformerException e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.core", "could not write repositories", (Throwable)e));
            throw new IOException(e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestResultsInputSource
    extends InputSource {
        private final Map<String, TestResultExternalizer.TestSuite> testResults;
        private final BambooBuild build;
        private final int failed;
        private final int success;

        public TestResultsInputSource(Map<String, TestResultExternalizer.TestSuite> testResults, BambooBuild build, int failed, int success) {
            this.build = build;
            this.testResults = testResults;
            this.failed = failed;
            this.success = success;
        }

        public Map<String, TestResultExternalizer.TestSuite> getTestResults() {
            return this.testResults;
        }

        public BambooBuild getBuild() {
            return this.build;
        }

        public int getFailed() {
            return this.failed;
        }

        public int getSuccess() {
            return this.success;
        }
    }

    private static class TestResultsWriter
    implements XMLReader {
        private ContentHandler handler;
        private ErrorHandler errorHandler;

        private TestResultsWriter() {
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public void setEntityResolver(EntityResolver resolver) {
        }

        public EntityResolver getEntityResolver() {
            return null;
        }

        public void setDTDHandler(DTDHandler dtdHandler) {
        }

        public DTDHandler getDTDHandler() {
            return null;
        }

        public void setContentHandler(ContentHandler dtdHandler) {
            this.handler = dtdHandler;
        }

        public ContentHandler getContentHandler() {
            return this.handler;
        }

        public void setErrorHandler(ErrorHandler dtdHandler) {
            this.errorHandler = dtdHandler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void parse(InputSource input) throws IOException, SAXException {
            if (!(input instanceof TestResultsInputSource)) {
                throw new SAXException("Can only parse writable input sources");
            }
            Map<String, TestResultExternalizer.TestSuite> testSuites = ((TestResultsInputSource)input).getTestResults();
            BambooBuild build = ((TestResultsInputSource)input).getBuild();
            int failed = ((TestResultsInputSource)input).getFailed();
            int success = ((TestResultsInputSource)input).getSuccess();
            this.handler.startDocument();
            AttributesImpl rootAttributes = new AttributesImpl();
            rootAttributes.addAttribute("", "name", "name", "", "{bamboo imported} " + build.getPlanKey() + "-" + build.getNumber());
            rootAttributes.addAttribute("", "project", "project", "", "{bamboo imported} " + build.getPlanKey() + "-" + build.getNumber());
            rootAttributes.addAttribute("", "tests", "tests", "", String.valueOf(failed + success));
            rootAttributes.addAttribute("", "started", "started", "", String.valueOf(failed + success));
            rootAttributes.addAttribute("", "failures", "failures", "", String.valueOf(failed));
            rootAttributes.addAttribute("", "errors", "errors", "", "0");
            rootAttributes.addAttribute("", "ignored", "ignored", "", "0");
            this.handler.startElement("", "testrun", "testrun", rootAttributes);
            for (TestResultExternalizer.TestSuite testsuite : testSuites.values()) {
                AttributesImpl suiteAttributes = new AttributesImpl();
                suiteAttributes.addAttribute("", "name", "name", "", testsuite.getClassName());
                suiteAttributes.addAttribute("", "time", "time", "", String.valueOf(testsuite.getTotalDuration()));
                this.handler.startElement("", "testsuite", "testsuite", suiteAttributes);
                for (TestDetails test : testsuite.getTests()) {
                    AttributesImpl testAttributes = new AttributesImpl();
                    testAttributes.addAttribute("", "name", "name", "", test.getTestMethodName());
                    testAttributes.addAttribute("", "classname", "classname", "", test.getTestClassName());
                    testAttributes.addAttribute("", "time", "time", "", String.valueOf(test.getTestDuration()));
                    this.handler.startElement("", "testcase", "testcase", testAttributes);
                    if (test.getTestResult() == TestResult.TEST_FAILED) {
                        this.handler.startElement("", "failure", "failure", new AttributesImpl());
                        this.handler.characters(test.getErrors().toCharArray(), 0, test.getErrors().length());
                        this.handler.endElement("", "failure", "failure");
                    }
                    this.handler.endElement("", "testcase", "testcase");
                }
                this.handler.endElement("", "testsuite", "testsuite");
            }
            this.handler.endElement("", "testrun", "testrun");
            this.handler.endDocument();
        }

        public void parse(String systemId) throws IOException, SAXException {
            throw new SAXException("Can only parse writable input sources");
        }
    }
}

