/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.graph.AbstractConfigGraphicalEditor;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.parts.IPaletteFactory;
import org.springframework.ide.eclipse.config.graph.parts.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public abstract class AbstractConfigPaletteFactory {
    private final AbstractConfigGraphicalEditor editor;
    private PaletteRoot root;
    private List<PaletteDrawer> adapterDrawers;

    public static Image createScaledImage(Image image, double scale) {
        int width = image.getBounds().width;
        int height = image.getBounds().height;
        return new Image(image.getDevice(), image.getImageData().scaledTo((int)((double)width * scale), (int)((double)height * scale)));
    }

    public AbstractConfigPaletteFactory(AbstractConfigGraphicalEditor editor) {
        this.editor = editor;
        this.createPaletteRoot();
    }

    private List<PaletteDrawer> createAdapterDrawers() {
        this.adapterDrawers = new ArrayList<PaletteDrawer>();
        for (IConfigurationElement config : this.editor.getAdapterDefinitions()) {
            String uri = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI);
            if (!this.editor.getEditor().containsNamespaceUri(uri)) continue;
            try {
                IPaletteFactory factory;
                PaletteDrawer drawer;
                Object obj = config.createExecutableExtension(PageAdaptersExtensionPointConstants.ATTR_PALETTE_FACTORY);
                String label = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_LABEL);
                if (!(obj instanceof IPaletteFactory) || (drawer = (factory = (IPaletteFactory)obj).createPaletteDrawer(this.getDiagram(), uri)) == null) continue;
                drawer.setLabel(label);
                drawer.setInitialState(1);
                this.adapterDrawers.add(drawer);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.graph", Messages.AbstractConfigPaletteFactory_ERROR_CREATING_PALETTE, (Throwable)e));
            }
        }
        Collections.sort(this.adapterDrawers, new AdapterComparator());
        return this.adapterDrawers;
    }

    protected List<PaletteEntry> createCategories() {
        ArrayList<PaletteEntry> categories = new ArrayList<PaletteEntry>();
        categories.add((PaletteEntry)this.createControlGroup());
        categories.addAll(this.createComponentDrawers());
        categories.addAll(this.createAdapterDrawers());
        return categories;
    }

    protected abstract List<PaletteDrawer> createComponentDrawers();

    protected abstract List<PaletteEntry> createConnectionTools();

    protected PaletteContainer createControlGroup() {
        PaletteGroup group = new PaletteGroup(Messages.AbstractConfigPaletteFactory_CONTROL_GROUP_TITLE);
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        this.root.setDefaultEntry((ToolEntry)tool);
        List<PaletteEntry> connections = this.createConnectionTools();
        if (connections != null && connections.size() > 0) {
            PaletteSeparator sep = new PaletteSeparator();
            sep.setUserModificationPermission(1);
            entries.add(sep);
            entries.addAll(connections);
        }
        group.addAll(entries);
        return group;
    }

    private void createPaletteRoot() {
        this.root = new PaletteRoot();
        this.root.addAll(this.createCategories());
    }

    public AbstractConfigGraphDiagram getDiagram() {
        return this.editor.getDiagram();
    }

    public PaletteRoot getPaletteRoot() {
        return this.root;
    }

    public void updatePalette() {
        for (PaletteDrawer drawer : this.adapterDrawers) {
            this.root.remove((PaletteEntry)drawer);
        }
        this.root.addAll(this.createAdapterDrawers());
    }

    private class AdapterComparator
    implements Comparator<PaletteDrawer> {
        private AdapterComparator() {
        }

        @Override
        public int compare(PaletteDrawer o1, PaletteDrawer o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    }
}

