/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphImages;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.config.graph.AbstractConfigGraphicalEditor;
import org.springframework.ide.eclipse.config.graph.actions.Messages;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class ExportAction
extends WorkbenchPartAction {
    public static final String ID = "Export_action";
    private final AbstractConfigGraphicalEditor editor;

    public ExportAction(AbstractConfigGraphicalEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
        this.setText(Messages.ExportAction_ACTION_LABEL);
        this.setId(ID);
        this.setToolTipText(Messages.ExportAction_TOOLTIP_LABEL);
        this.setImageDescriptor(BeansGraphImages.DESC_OBJS_EXPORT_ENABLED);
        this.setDisabledImageDescriptor(BeansGraphImages.DESC_OBJS_EXPORT_DISABLED);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        SaveAsDialog dialog = new SaveAsDialog(this.getWorkbenchPart().getSite().getShell());
        dialog.setOriginalName(Messages.ExportAction_JPEG_ORIGINAL_TITLE);
        dialog.create();
        dialog.setMessage(BeansGraphPlugin.getResourceString((String)"Editor.SaveAsDialog.message"));
        dialog.setOriginalName(Messages.ExportAction_PNG_ORIGINAL_TITLE);
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(path);
            String ext = file.getFileExtension();
            if (ext == null || ext.length() == 0 || !ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("bmp") && !ext.equalsIgnoreCase("png")) {
                ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)BeansGraphPlugin.getResourceString((String)"Editor.SaveError.title"), null, (IStatus)BeansGraphPlugin.createErrorStatus((String)BeansGraphPlugin.getResourceString((String)"Editor.SaveAsDialog.error")));
            } else if (ext.equalsIgnoreCase("PNG") && !SpringCoreUtils.isEclipseSameOrNewer((int)3, (int)3)) {
                ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.ExportAction_ERROR_TITLE, (String)Messages.ExportAction_ERROR_PNG_EXPORT_33_OR_NEWER, (IStatus)BeansGraphPlugin.createErrorStatus((String)BeansGraphPlugin.getResourceString((String)"Editor.SaveAsDialog.error")));
            } else if ("PNG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 5);
            } else if ("JPG".equalsIgnoreCase(ext) || "JPEG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 4);
            } else if ("BMP".equalsIgnoreCase(ext)) {
                this.saveImage(file, 0);
            }
        }
    }

    public void saveImage(final IFile file, final int format) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)new ByteArrayInputStream(ExportAction.this.editor.createImage(format)), true, false, monitor);
                    } else {
                        file.create((InputStream)new ByteArrayInputStream(ExportAction.this.editor.createImage(format)), true, monitor);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)ExportAction.this.getWorkbenchPart().getSite().getShell(), (String)BeansGraphPlugin.getResourceString((String)"Editor.SaveError.title"), (String)BeansGraphPlugin.getResourceString((String)"Editor.SaveError.text"), (IStatus)e.getStatus());
                }
            }
        };
        try {
            Shell shell = this.getWorkbenchPart().getSite().getWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            BeansGraphPlugin.log((Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
    }
}

