/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.springframework.ide.eclipse.beans.ui.refactoring.model.BeansJavaConfigTypeChange;

public class BeansJavaConfigRenameTypeRefactoringParticipant
extends RenameParticipant {
    private IType type;

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this.type = (IType)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Update references in Spring project configurations";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        String newName = this.getArguments().getNewName();
        if (this.type.getDeclaringType() != null) {
            newName = String.valueOf(this.type.getDeclaringType().getFullyQualifiedName()) + "$" + newName;
        } else if (!this.type.getPackageFragment().isDefaultPackage()) {
            newName = String.valueOf(this.type.getPackageFragment().getElementName()) + "." + newName;
        }
        return new BeansJavaConfigTypeChange(this.type, newName);
    }
}

