/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.ltk;

import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.ui.refactoring.ltk.RenameIdRefactoring;

public class RenameIdRefactoringInputPage
extends UserInputWizardPage {
    private Text nameField;

    public RenameIdRefactoringInputPage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        final RenameIdRefactoring refactoring = this.getRenameIdRefactoring();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("&" + refactoring.getType().getType() + " id:");
        this.nameField = this.createNameField(result);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        final Button referenceButton = new Button(result, 32);
        referenceButton.setText("&Update references");
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 2;
        referenceButton.setLayoutData((Object)data);
        this.nameField.setText(refactoring.getBeanId());
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RenameIdRefactoringInputPage.this.handleInputChanged();
            }
        });
        referenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((RefactoringWizard)RenameIdRefactoringInputPage.this.getWizard()).setForcePreviewReview(referenceButton.getSelection());
                refactoring.setUpdateReferences(referenceButton.getSelection());
            }
        });
        referenceButton.setSelection(true);
        ((RefactoringWizard)this.getWizard()).setForcePreviewReview(true);
        this.nameField.setFocus();
        this.nameField.selectAll();
        this.handleInputChanged();
    }

    private Text createNameField(Composite result) {
        Text field = new Text(result, 18436);
        field.setLayoutData((Object)new GridData(768));
        return field;
    }

    private RenameIdRefactoring getRenameIdRefactoring() {
        return (RenameIdRefactoring)this.getRefactoring();
    }

    void handleInputChanged() {
        RefactoringStatus status = new RefactoringStatus();
        RenameIdRefactoring refactoring = this.getRenameIdRefactoring();
        status.merge(refactoring.setBeanId(this.nameField.getText()));
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }
}

