/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.ui.Activator;

public class AopReferenceModelImages {
    private static final String ICON_PATH_PREFIX = "icons/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.aop.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.aop.ui.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_ASPECT = "org.springframework.ide.eclipse.aop.ui.aspect.gif";
    public static final String IMG_OBJS_FILE = "org.springframework.ide.eclipse.aop.ui.file.gif";
    public static final String IMG_OBJS_ADVICE = "org.springframework.ide.eclipse.aop.ui.advice.gif";
    public static final String IMG_OBJS_AROUND_ADVICE = "org.springframework.ide.eclipse.aop.ui.around_advice.gif";
    public static final String IMG_OBJS_BEFORE_ADVICE = "org.springframework.ide.eclipse.aop.ui.before_advice.gif";
    public static final String IMG_OBJS_AFTER_ADVICE = "org.springframework.ide.eclipse.aop.ui.after_advice.gif";
    public static final String IMG_OBJS_INTRODUCTION = "org.springframework.ide.eclipse.aop.ui.itd.gif";
    public static final String IMG_OBJS_CONFIG = "org.springframework.ide.eclipse.aop.ui.ajcu_obj.gif";
    public static final String IMG_OBJS_POINTCUT = "org.springframework.ide.eclipse.aop.ui.pointcut_def.gif";
    public static final String IMG_OVR_ADVICE = "org.springframework.ide.eclipse.aop.ui.advice_overlay.gif";
    public static final String IMG_OVR_SPRING = "org.springframework.ide.eclipse.aop.ui.spring_overlay.gif";
    public static final String IMG_OVR_ANNOTATION = "org.springframework.ide.eclipse.aop.ui.annotation_overlay.gif";
    private static final String STRUCTURE = "structure/";
    public static final ImageDescriptor DESC_OBJS_ASPECT;
    public static final ImageDescriptor DESC_OBJS_FILE;
    public static final ImageDescriptor DESC_OBJS_ADVICE;
    public static final ImageDescriptor DESC_OBJS_AROUND_ADVICE;
    public static final ImageDescriptor DESC_OBJS_BEFORE_ADVICE;
    public static final ImageDescriptor DESC_OBJS_AFTER_ADVICE;
    public static final ImageDescriptor DESC_OBJS_INTRODUCTION;
    public static final ImageDescriptor DESC_OBJS_CONFIG;
    public static final ImageDescriptor DESC_OBJS_POINTCUT;
    public static final ImageDescriptor DESC_OVR_ADVICE;
    public static final ImageDescriptor DESC_OVR_SPRING;
    public static final ImageDescriptor DESC_OVR_ANNOTATION;

    static {
        try {
            ICON_BASE_URL = new URL(Activator.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        DESC_OBJS_ASPECT = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_ASPECT);
        DESC_OBJS_FILE = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_FILE);
        DESC_OBJS_ADVICE = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_ADVICE);
        DESC_OBJS_AROUND_ADVICE = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_AROUND_ADVICE);
        DESC_OBJS_BEFORE_ADVICE = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_BEFORE_ADVICE);
        DESC_OBJS_AFTER_ADVICE = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_AFTER_ADVICE);
        DESC_OBJS_INTRODUCTION = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_INTRODUCTION);
        DESC_OBJS_CONFIG = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_CONFIG);
        DESC_OBJS_POINTCUT = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OBJS_POINTCUT);
        DESC_OVR_ADVICE = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OVR_ADVICE);
        DESC_OVR_SPRING = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OVR_SPRING);
        DESC_OVR_ANNOTATION = AopReferenceModelImages.createManaged(STRUCTURE, IMG_OVR_ANNOTATION);
    }

    public static Image getImage(String key) {
        return AopReferenceModelImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        AopReferenceModelImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        AopReferenceModelImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            Iterator<String> iterator = imageDescriptors.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String key = string = iterator.next();
                imageRegistry.put(key, imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)AopReferenceModelImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        action.setImageDescriptor(AopReferenceModelImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)AopReferenceModelImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            if (imageRegistry != null) {
                Activator.log("Image registry already defined", null);
            }
            return result;
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)AopReferenceModelImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

