/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.internal.navigator;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.ui.SpringUIImages;
import org.springframework.ide.eclipse.ui.SpringUILabelProvider;

public class SpringNavigatorLabelProvider
extends SpringUILabelProvider
implements ICommonLabelProvider {
    private static final String SPRING_EXPLORER_LABEL = "Spring Explorer";
    private static final String SPRING_ELEMENTS_LABEL = "Spring Elements";
    private String providerId;

    public SpringNavigatorLabelProvider() {
        super(true);
    }

    public void init(ICommonContentExtensionSite config) {
        this.providerId = config.getExtension().getId();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public String getDescription(Object element) {
        if (element instanceof ISpringProject) {
            if ("org.springframework.ide.eclipse.ui.navigator.projectExplorerContent".equals(this.providerId)) {
                return SPRING_ELEMENTS_LABEL + " - " + ((ISpringProject)element).getProject().getName();
            }
            if ("org.springframework.ide.eclipse.ui.navigator.springExplorerContent".equals(this.providerId)) {
                return ((ISpringProject)element).getElementName();
            }
        }
        return null;
    }

    public String toString() {
        return this.providerId;
    }

    @Override
    protected Image getImage(Object element, Object parentElement) {
        if (element instanceof ISpringProject && "org.springframework.ide.eclipse.ui.navigator.projectExplorerContent".equals(this.providerId)) {
            return SpringUIImages.getImage("org.springframework.ide.eclipse.ui.spring_obj.gif");
        }
        return super.getImage(element, parentElement);
    }

    @Override
    protected String getText(Object element, Object parentElement) {
        if (element instanceof ISpringProject && "org.springframework.ide.eclipse.ui.navigator.projectExplorerContent".equals(this.providerId)) {
            return SPRING_ELEMENTS_LABEL;
        }
        if (element instanceof IWorkspaceRoot) {
            return SPRING_EXPLORER_LABEL;
        }
        return super.getText(element, parentElement);
    }
}

