/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringModel;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;

public class SpringNavigatorContentProvider
implements ICommonContentProvider,
IModelChangeListener {
    private boolean refresh;
    private StructuredViewer viewer;
    private String providerID;

    public SpringNavigatorContentProvider() {
        this(true);
    }

    public SpringNavigatorContentProvider(boolean refresh) {
        this.refresh = refresh;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            if (this.refresh) {
                if (oldInput == null && newInput != null) {
                    SpringCore.getModel().addChangeListener((IModelChangeListener)this);
                } else if (oldInput != null && newInput == null) {
                    SpringCore.getModel().removeChangeListener((IModelChangeListener)this);
                }
            }
        } else {
            this.viewer = null;
        }
    }

    public void dispose() {
        if (this.refresh) {
            SpringCore.getModel().removeChangeListener((IModelChangeListener)this);
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkingSet) {
            return IModelElement.NO_CHILDREN;
        }
        return SpringCore.getModel().getProjects().toArray();
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        ISpringProject springProject;
        if ("org.springframework.ide.eclipse.ui.navigator.projectExplorerContent".equals(this.providerID) && parentElement instanceof IProject && (springProject = SpringCore.getModel().getProject((IProject)parentElement)) != null) {
            return new Object[]{springProject};
        }
        return IModelElement.NO_CHILDREN;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void init(ICommonContentExtensionSite config) {
        this.providerID = config.getExtension().getId();
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void elementChanged(ModelChangeEvent event) {
        IModelElement element = event.getElement();
        if (event.getType() == ModelChangeEvent.Type.CHANGED) {
            this.refreshViewerForElement(element);
        } else if (element.getElementParent() instanceof ISpringModel) {
            this.refreshViewerForElement(ResourcesPlugin.getWorkspace().getRoot());
        } else {
            this.refreshViewerForElement(element.getElementParent());
        }
    }

    protected final StructuredViewer getViewer() {
        return this.viewer;
    }

    protected final void refreshViewerForElement(final Object element) {
        if (this.viewer instanceof StructuredViewer && element != null) {
            Control ctrl = this.viewer.getControl();
            if (ctrl == null || ctrl.isDisposed()) {
                return;
            }
            if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
                this.viewer.refresh(element);
            } else {
                ctrl.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control ctrl = SpringNavigatorContentProvider.this.viewer.getControl();
                        if (ctrl == null || ctrl.isDisposed()) {
                            return;
                        }
                        if (element instanceof ISpringModel) {
                            SpringNavigatorContentProvider.this.viewer.refresh();
                        } else {
                            SpringNavigatorContentProvider.this.viewer.refresh(element);
                        }
                    }
                });
            }
        }
    }

    public String toString() {
        return String.valueOf(this.providerID);
    }
}

