/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;

public class GroupSection
extends WizardPageSection {
    List<WizardPageSection> sections;
    private CompositeValidator validator;
    private String groupTitle;
    public final LiveVariable<Boolean> isVisible = new LiveVariable<Boolean>(true);
    private int columns = 1;

    public GroupSection(WizardPageWithSections owner, String title, WizardPageSection ... _sections) {
        super(owner);
        this.groupTitle = title;
        this.sections = new ArrayList<WizardPageSection>();
        WizardPageSection[] wizardPageSectionArray = _sections;
        int n = _sections.length;
        int n2 = 0;
        while (n2 < n) {
            WizardPageSection s = wizardPageSectionArray[n2];
            if (s != null) {
                this.sections.add(s);
            }
            ++n2;
        }
        this.validator = new CompositeValidator();
        for (WizardPageSection s : this.sections) {
            this.validator.addChild((LiveExpression)s.getValidator());
        }
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    @Override
    public void createContents(Composite page) {
        final Composite group = this.createComposite(page);
        for (WizardPageSection s : this.sections) {
            s.createContents(group);
        }
        this.isVisible.addListener(new ValueListener<Boolean>(){

            @Override
            public void gotValue(LiveExpression<Boolean> exp, Boolean isVisible) {
                group.setVisible(isVisible.booleanValue());
                GridData layout = (GridData)group.getLayoutData();
                layout.exclude = isVisible == false;
                group.setLayoutData((Object)layout);
                GroupSection.this.owner.getShell().layout(new Control[]{group});
            }
        });
    }

    private Composite createComposite(Composite page) {
        if (this.groupTitle != null) {
            Group group = new Group(page, 0);
            group.setText(this.groupTitle);
            group.setLayout((Layout)this.createLayout());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            return group;
        }
        Composite composite = new Composite(page, 0);
        composite.setLayout((Layout)this.createLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        return composite;
    }

    protected GridLayout createLayout() {
        GridLayout layout = new GridLayout(this.columns, true);
        if (this.groupTitle == null) {
            layout.marginWidth = 0;
        }
        return layout;
    }

    @Override
    public void dispose() {
        for (WizardPageSection s : this.sections) {
            s.dispose();
        }
        super.dispose();
    }

    public GroupSection columns(int i) {
        Assert.isLegal((i >= 1 ? 1 : 0) != 0);
        this.columns = i;
        return this;
    }
}

