/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.workspace;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.OperationCanceledException;

public class ProjectChangeListenerManager
implements IResourceChangeListener {
    private IWorkspace workspace;
    private ProjectChangeListener listener;

    public ProjectChangeListenerManager(IWorkspace workspace, ProjectChangeListener listener) {
        this.workspace = workspace;
        this.listener = listener;
        this.workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projDeltas = delta.getAffectedChildren(7);
            int i = 0;
            while (i < projDeltas.length) {
                IResource resource = projDeltas[i].getResource();
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    this.projectChanged(project);
                }
                ++i;
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void projectChanged(IProject project) {
        this.listener.projectChanged(project);
    }

    public void dispose() {
        if (this.listener != null) {
            this.workspace.removeResourceChangeListener((IResourceChangeListener)this);
            this.listener = null;
        }
    }

    public static interface ProjectChangeListener {
        public void projectChanged(IProject var1);
    }
}

