/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.internal.commands;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.BooleanParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ComboParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.CommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.CompositeCommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.CompositeParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IParameterFactory;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.JavaParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterKind;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.StringCommandParameter;

public class ParameterFactory
implements IParameterFactory {
    @Override
    public ICommandParameter getParameter(ICommandParameterDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        ParameterKind kind = descriptor.getParameterKind();
        switch (kind) {
            case BASE: 
            case JAVA_TYPE: {
                return new StringCommandParameter(descriptor);
            }
            case COMBO: 
            case BOOLEAN: {
                return new CommandParameter(descriptor);
            }
            case COMPOSITE: {
                return new CompositeCommandParameter((CompositeParameterDescriptor)descriptor);
            }
        }
        return null;
    }

    public static ICommandParameterDescriptor createCompositeParameterDescriptor(String name, String description, boolean isMandatory, String defaultValue, boolean requiresName, String delimiter, String valueSeparator, List<ICommandParameterDescriptor> descriptors) {
        return new CompositeParameterDescriptor(name, description, isMandatory, (Object)defaultValue, requiresName, delimiter, valueSeparator, descriptors);
    }

    public static ICommandParameterDescriptor createBooleanParameterDescriptor(String name, String description, boolean isMandatory, boolean defaultValue, boolean requiresName, String prefix, String valueSeparator) {
        return new BooleanParameterDescriptor(name, description, isMandatory, defaultValue, requiresName, prefix, valueSeparator);
    }

    public static ICommandParameterDescriptor createBooleanParameterDescriptor(String name, String description, boolean isMandatory, boolean defaultValue, String prefix) {
        return new BooleanParameterDescriptor(name, description, isMandatory, defaultValue, prefix);
    }

    public static ICommandParameterDescriptor createBaseParameterDescriptor(String name, String description, boolean isMandatory, String defaultValue, boolean requiresName, String prefix, String valueSeparator) {
        return new ParameterDescriptor(name, description, isMandatory, defaultValue, ParameterKind.BASE, requiresName, prefix, valueSeparator);
    }

    public static ICommandParameterDescriptor createJavaParameterDescriptor(String name, String description, boolean isMandatory, String defaultValue, boolean requiresName, String prefix, String valueSeparator, int type) {
        return new JavaParameterDescriptor(name, description, isMandatory, defaultValue, ParameterKind.JAVA_TYPE, type, requiresName, prefix, valueSeparator);
    }

    public static ICommandParameterDescriptor createComboParameterDescriptor(String name, String description, boolean isMandatory, String defaultValue, boolean requiresName, String prefix, String valueSeparator, String[] values) {
        return new ComboParameterDescriptor(name, description, isMandatory, (Object)defaultValue, requiresName, prefix, valueSeparator, values);
    }

    public static ICommandParameterDescriptor createBasePrefixedParameterDescriptor(String name, String description, boolean isMandatory, String defaultValue) {
        return ParameterFactory.createBaseParameterDescriptor(name, description, isMandatory, defaultValue, true, "--", "=");
    }

    public static ICommandParameter getParameterInstance(ICommandParameterDescriptor descriptor) {
        IParameterFactory factory;
        if (descriptor instanceof IAdaptable && (factory = (IParameterFactory)((IAdaptable)descriptor).getAdapter(IParameterFactory.class)) != null) {
            return factory.getParameter(descriptor);
        }
        return null;
    }
}

