/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.comments;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommentTemplateEditDialog;

public class CommentTemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionChangedListener {
    private ListViewer viewer;
    private Button editButton;
    private Button removeButton;
    private Text preview;
    private Text commentsText;
    public static final int MAX_COMMENTS_TO_SAVE = 100;

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        Composite templateGroup = this.createListAndButtons(parent);
        Group previewGroup = new Group(templateGroup, 0);
        previewGroup.setText(Policy.bind("CommentTemplatesPreferencePage.Preview"));
        GridLayout previewLayout = new GridLayout();
        previewLayout.marginWidth = 0;
        previewLayout.marginHeight = 0;
        previewGroup.setLayout((Layout)previewLayout);
        previewGroup.setLayoutData((Object)new GridData(1808));
        this.preview = new Text((Composite)previewGroup, 10);
        GridData gd = new GridData(768);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.preview.setLayoutData((Object)gd);
        Composite commentsGroup = new Composite(parent, 0);
        GridLayout commentsLayout = new GridLayout();
        commentsLayout.marginWidth = 0;
        commentsLayout.marginHeight = 0;
        commentsLayout.numColumns = 3;
        commentsGroup.setLayout((Layout)commentsLayout);
        commentsGroup.setLayoutData((Object)new GridData());
        Label commentsLabel = new Label(commentsGroup, 0);
        commentsLabel.setText(Policy.bind("CommentTemplatesPreferencePage.0"));
        this.commentsText = new Text(commentsGroup, 2048);
        gd = new GridData();
        gd.widthHint = 50;
        this.commentsText.setLayoutData((Object)gd);
        this.commentsText.setText(Integer.toString(SVNUIPlugin.getPlugin().getPreferenceStore().getInt("pref_comments_to_save")));
        this.commentsText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }
        });
        this.commentsText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = e.text;
                int i = 0;
                while (i < text.length()) {
                    if ("0123456789".indexOf(text.substring(i, i + 1)) == -1) {
                        e.doit = false;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.commentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CommentTemplatesPreferencePage.this.getCommentsToSave() > 100) {
                    CommentTemplatesPreferencePage.this.setValid(false);
                    CommentTemplatesPreferencePage.this.setErrorMessage(String.valueOf(Policy.bind("CommentTemplatesPreferencePage.1")) + " " + 100 + ".");
                } else {
                    CommentTemplatesPreferencePage.this.setValid(true);
                    CommentTemplatesPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        Label rangeLabel = new Label(commentsGroup, 0);
        rangeLabel.setText("(0-100)");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.tigris.subversion.subclipse.ui.comment_template_preference_page_context");
        Dialog.applyDialogFont((Control)ancestor);
        return parent;
    }

    private Composite createListAndButtons(Composite parent) {
        Group templateGroup = new Group(parent, 0);
        templateGroup.setText(Policy.bind("CommentTemplatesPreferencePage.2"));
        GridLayout templateLayout = new GridLayout();
        templateLayout.marginWidth = 0;
        templateLayout.marginHeight = 0;
        templateGroup.setLayout((Layout)templateLayout);
        templateGroup.setLayoutData((Object)new GridData(1808));
        Composite listAndButtons = new Composite((Composite)templateGroup, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        listAndButtons.setLayout((Layout)layout);
        listAndButtons.setLayoutData((Object)new GridData(1808));
        this.viewer = new ListViewer(listAndButtons);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String template = (String)element;
                return Util.flattenText((String)template);
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String template1 = Util.flattenText((String)((String)e1));
                String template2 = Util.flattenText((String)((String)e2));
                return template1.compareToIgnoreCase(template2);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommentTemplatesPreferencePage.this.editTemplate();
            }
        });
        List list = this.viewer.getList();
        list.setLayoutData((Object)new GridData(1808));
        String[] templates = SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().getCommentTemplates();
        int i = 0;
        while (i < templates.length) {
            this.viewer.add((Object)templates[i]);
            ++i;
        }
        this.createButtons(listAndButtons);
        return templateGroup;
    }

    private void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button newButton = new Button(buttons, 8);
        newButton.setText(Policy.bind("CommentTemplatesPreferencePage.New"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, newButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        newButton.setLayoutData((Object)data);
        newButton.setEnabled(true);
        newButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommentTemplatesPreferencePage.this.newTemplate();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(Policy.bind("CommentTemplatesPreferencePage.Edit"));
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.editButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.editButton.setLayoutData((Object)data);
        this.editButton.setEnabled(false);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommentTemplatesPreferencePage.this.editTemplate();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Policy.bind("CommentTemplatesPreferencePage.Remove"));
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommentTemplatesPreferencePage.this.remove();
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        switch (selection.size()) {
            case 0: {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.preview.setText("");
                break;
            }
            case 1: {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.preview.setText((String)selection.getFirstElement());
                break;
            }
            default: {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(true);
                this.preview.setText("");
            }
        }
    }

    void newTemplate() {
        CommentTemplateEditDialog dialog = new CommentTemplateEditDialog(this.getShell(), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateTitle"), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateMessage"), "", null);
        if (dialog.open() == 0) {
            this.viewer.add((Object)dialog.getValue());
        }
    }

    void editTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            String oldTemplate = (String)selection.getFirstElement();
            CommentTemplateEditDialog dialog = new CommentTemplateEditDialog(this.getShell(), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateTitle"), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateMessage"), oldTemplate, null);
            if (dialog.open() == 0) {
                this.viewer.remove((Object)oldTemplate);
                this.viewer.add((Object)dialog.getValue());
            }
        }
    }

    void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.viewer.remove(selection.toArray());
    }

    public boolean performOk() {
        int numTemplates = this.viewer.getList().getItemCount();
        String[] templates = new String[numTemplates];
        int i = 0;
        while (i < numTemplates) {
            templates[i] = (String)this.viewer.getElementAt(i);
            ++i;
        }
        try {
            SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().replaceAndSaveCommentTemplates(templates);
        }
        catch (TeamException e) {
            SVNUIPlugin.openError(this.getShell(), null, null, e, 8);
        }
        SVNUIPlugin.getPlugin().getPreferenceStore().setValue("pref_comments_to_save", this.getCommentsToSave());
        return super.performOk();
    }

    private int getCommentsToSave() {
        int commentsToRemember = this.commentsText.getText().trim().length() == 0 ? 0 : Integer.parseInt(this.commentsText.getText());
        return commentsToRemember;
    }
}

