/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorFactory;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigFilesTab;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigLocatorTab;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigSetsTab;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class ProjectPropertyPage
extends PropertyPage {
    public static final String ID = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage";
    public static final String BLOCK_ID = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.blockId";
    public static final String SCAN = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.scan";
    public static final String SELECTED_RESOURCE = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.selectedResource";
    private static final String PREFIX = "ConfigurationPropertyPage.";
    private static final String TITLE = "ConfigurationPropertyPage.title";
    private static final String CONFIG_FILES_LABEL = "ConfigurationPropertyPage.tabConfigFiles.label";
    private static final String CONFIG_SETS_LABEL = "ConfigurationPropertyPage.tabConfigSets.label";
    private static final String CONFIG_LOCATORS_LABEL = "ConfigurationPropertyPage.tabConfigLocators.label";
    private PropertiesModel model;
    private ConfigFilesTab configFilesTab;
    private ConfigSetsTab configSetsTab;
    private int selectedTab;
    private IModelElement selectedModelElement;
    private Map<String, Object> pageData;
    private ConfigLocatorTab configLocatorTab;
    private boolean shouldTriggerScan = false;

    public ProjectPropertyPage() {
        this(null, 0);
    }

    public ProjectPropertyPage(IProject project) {
        this(project, 0);
    }

    public ProjectPropertyPage(IProject project, int selectedTab) {
        this.setElement((IAdaptable)project);
        this.setTitle(BeansUIPlugin.getResourceString(TITLE));
        this.noDefaultAndApplyButton();
        this.selectedTab = selectedTab;
    }

    protected Control createContents(Composite parent) {
        IProject project = (IProject)this.getElement();
        this.model = new PropertiesModel();
        PropertiesProject modelProject = new PropertiesProject(this.model, BeansCorePlugin.getModel().getProject(project));
        this.model.addProject(modelProject);
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(1808));
        this.configFilesTab = new ConfigFilesTab(this.model, modelProject, this.selectedModelElement);
        TabItem item = new TabItem(folder, 0);
        item.setText(BeansUIPlugin.getResourceString(CONFIG_FILES_LABEL));
        item.setControl(this.configFilesTab.createControl((Composite)folder));
        this.configSetsTab = new ConfigSetsTab(this.model, modelProject, this.selectedModelElement);
        item = new TabItem(folder, 0);
        item.setText(BeansUIPlugin.getResourceString(CONFIG_SETS_LABEL));
        item.setControl(this.configSetsTab.createControl((Composite)folder));
        if (BeansConfigLocatorFactory.hasEnabledBeansConfigLocatorDefinitions((IProject)project)) {
            this.configLocatorTab = new ConfigLocatorTab(modelProject.getProject());
            item = new TabItem(folder, 0);
            item.setText(BeansUIPlugin.getResourceString(CONFIG_LOCATORS_LABEL));
            item.setControl(this.configLocatorTab.createContents((Composite)folder));
        }
        Dialog.applyDialogFont((Control)folder);
        folder.setSelection(this.selectedTab);
        if (this.shouldTriggerScan) {
            this.configFilesTab.handleScanButtonPressed();
        }
        return folder;
    }

    public boolean performOk() {
        IProject project = (IProject)this.getElement();
        IBeansProject currentProject = BeansCorePlugin.getModel().getProject(project);
        boolean userMadeChanges = this.configFilesTab.hasUserMadeChanges() || this.configSetsTab.hasUserMadeChanges();
        PropertiesProject newProject = (PropertiesProject)this.model.getProject(project);
        if (this.configFilesTab.hasUserMadeChanges()) {
            for (IBeansConfig currentConfig : currentProject.getConfigs()) {
                if (newProject.hasConfig(currentConfig.getElementName())) continue;
                MarkerUtils.deleteAllMarkers((IResource)currentConfig.getElementResource(), (String)"org.springframework.ide.eclipse.core.problemmarker");
            }
        }
        if (userMadeChanges) {
            SpringCorePreferences.getProjectPreferences((IProject)project.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("ignoreMissingNamespaceHandler", this.configFilesTab.shouldIgnoreMissingNamespaceHandler());
            newProject.saveDescription();
        }
        if (this.configLocatorTab != null) {
            this.configLocatorTab.performOk();
        }
        if (this.configFilesTab.hasUserMadeChanges()) {
            BeansModelLabelDecorator.update();
        }
        return super.performOk();
    }

    public void dispose() {
        if (this.configFilesTab != null) {
            this.configFilesTab.dispose();
        }
        if (this.configSetsTab != null) {
            this.configSetsTab.dispose();
        }
        super.dispose();
    }

    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof Map) {
            this.pageData = (Map)data;
            if (this.pageData.containsKey(BLOCK_ID)) {
                this.selectedTab = (Integer)this.pageData.get(BLOCK_ID);
            }
            if (this.pageData.containsKey(SELECTED_RESOURCE) && this.pageData.get(SELECTED_RESOURCE) instanceof IModelElement) {
                this.selectedModelElement = (IModelElement)this.pageData.get(SELECTED_RESOURCE);
            }
            if (this.pageData.containsKey(SCAN) && this.pageData.get(SCAN) instanceof Boolean) {
                this.shouldTriggerScan = (Boolean)this.pageData.get(SCAN);
            }
        }
    }
}

