/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.update;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.update.IBeansModelUpdate;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class UpdateFor252
implements IBeansModelUpdate {
    @Override
    public String getName() {
        return "Updating Spring model to 2.5.2 version";
    }

    @Override
    public boolean requiresUpdate(IBeansProject beansProject) {
        return beansProject.getProject().getFile(".springBeans").exists();
    }

    @Override
    public void updateProject(IBeansProject beansProject) {
        IFile oldFile = beansProject.getProject().getFile(".springBeans");
        IFile newFile = beansProject.getProject().getFile(".springBeans");
        if (oldFile.exists() && !newFile.exists()) {
            ((BeansProject)beansProject).saveDescription();
            try {
                if (SpringCoreUtils.validateEdit((IFile[])new IFile[]{oldFile})) {
                    oldFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                BeansCorePlugin.log("Problem deleting old '.springBeans'", e);
            }
        }
    }
}

