/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IAnnotationBasedHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class AbstractAnnotationBasedHyperlinkDetector
implements IAnnotationBasedHyperlinkDetector {
    @Override
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks, Node annotation) {
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        Node currentNode = BeansEditorUtils.getNodeByOffset(document, region.getOffset());
        if (currentNode != null) {
            switch (currentNode.getNodeType()) {
                case 1: {
                    Attr currentAttr = BeansEditorUtils.getAttrByOffset(currentNode, region.getOffset());
                    IDOMAttr attr = (IDOMAttr)currentAttr;
                    if (currentAttr == null || region.getOffset() < attr.getValueRegionStartOffset() || !this.isLinkableAttr(currentAttr, annotation)) break;
                    IRegion hyperlinkRegion = this.getHyperlinkRegion(currentAttr);
                    IHyperlink hyperLink = this.createHyperlink(currentAttr.getName(), currentAttr.getNodeValue(), currentNode, currentNode.getParentNode(), document, textViewer, hyperlinkRegion, region, annotation);
                    if (hyperLink == null) break;
                    return new IHyperlink[]{hyperLink};
                }
                case 3: {
                    IHyperlink hyperLink;
                    IRegion hyperlinkRegion = this.getHyperlinkRegion(currentNode);
                    Node parentNode = currentNode.getParentNode();
                    if (parentNode == null || (hyperLink = this.createHyperlink(parentNode.getNodeName(), currentNode.getNodeValue(), currentNode, parentNode, document, textViewer, hyperlinkRegion, region, annotation)) == null) break;
                    return new IHyperlink[]{hyperLink};
                }
            }
        }
        return null;
    }

    protected final IRegion getHyperlinkRegion(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 10: {
                    IDOMNode docNode = (IDOMNode)node;
                    return new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
                }
                case 1: {
                    IDOMElement element = (IDOMElement)node;
                    int endOffset = element.hasEndTag() && element.isClosed() ? element.getStartEndOffset() : element.getEndOffset();
                    return new Region(element.getStartOffset(), endOffset - element.getStartOffset());
                }
                case 2: {
                    IDOMAttr att = (IDOMAttr)node;
                    int regOffset = att.getValueRegionStartOffset();
                    int regLength = att.getValueRegionText().length();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    return new Region(regOffset, regLength);
                }
            }
        }
        return null;
    }

    public abstract IHyperlink createHyperlink(String var1, String var2, Node var3, Node var4, IDocument var5, ITextViewer var6, IRegion var7, IRegion var8, Node var9);

    public abstract boolean isLinkableAttr(Attr var1, Node var2);
}

