/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.namespaces;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigDetailsPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterPart;
import org.springframework.ide.eclipse.config.ui.editors.namespaces.Messages;
import org.springframework.ide.eclipse.config.ui.editors.namespaces.NamespacesMasterPart;

public class NamespacesDetailsPart
extends AbstractConfigDetailsPart {
    private INamespaceDefinition selectedNamespaceDefinition;
    private Map<INamespaceDefinition, String> selectedVersions;
    private CheckboxTableViewer versionViewer;

    public NamespacesDetailsPart(AbstractConfigMasterPart master) {
        super(master);
    }

    @Override
    protected void createDetailsContent(Composite client) {
        GridData data = new GridData(1808);
        data.heightHint = 50;
        data.widthHint = 50;
        this.versionViewer = CheckboxTableViewer.newCheckList((Composite)client, (int)2048);
        this.versionViewer.getTable().setLayoutData((Object)data);
        this.versionViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.versionViewer.setSorter(new ViewerSorter());
        this.versionViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    NamespacesDetailsPart.this.versionViewer.setCheckedElements(new Object[]{event.getElement()});
                    if (NamespacesDetailsPart.this.selectedNamespaceDefinition != null) {
                        NamespacesDetailsPart.this.selectedVersions.put(NamespacesDetailsPart.this.selectedNamespaceDefinition, (String)event.getElement());
                    }
                } else {
                    NamespacesDetailsPart.this.versionViewer.setCheckedElements(new Object[0]);
                    NamespacesDetailsPart.this.selectedVersions.remove(NamespacesDetailsPart.this.selectedNamespaceDefinition);
                }
                if (NamespacesDetailsPart.this.getMasterPart() instanceof NamespacesMasterPart) {
                    StructuredTextViewer textView = NamespacesDetailsPart.this.getConfigEditor().getTextViewer();
                    IDOMDocument doc = NamespacesDetailsPart.this.getConfigEditor().getDomDocument();
                    doc.getModel().beginRecording((Object)textView);
                    NamespacesMasterPart namespaceMaster = (NamespacesMasterPart)NamespacesDetailsPart.this.getMasterPart();
                    namespaceMaster.updateXsdVersion();
                    doc.getModel().endRecording((Object)textView);
                }
            }
        });
    }

    @Override
    protected String getDetailsSectionDescription() {
        return Messages.getString("NamespacesDetailsPart.DETAILS_SECTION_DESCRIPTION");
    }

    @Override
    protected String getDetailsSectionTitle() {
        return Messages.getString("NamespacesDetailsPart.DETAILS_SECTION_TITLE");
    }

    public ColumnViewer getVersionViewer() {
        return this.versionViewer;
    }

    @Override
    public void refresh() {
        if (this.getMasterPart() instanceof NamespacesMasterPart) {
            NamespacesMasterPart namespaceMaster = (NamespacesMasterPart)this.getMasterPart();
            this.selectedVersions = namespaceMaster.getSchemaVersions();
            if (this.selectedVersions.containsKey(this.selectedNamespaceDefinition)) {
                this.versionViewer.setCheckedElements(new Object[]{this.selectedVersions.get(this.selectedNamespaceDefinition).trim()});
            }
            if (this.getMasterViewer() instanceof CheckboxTableViewer) {
                CheckboxTableViewer checkViewer = (CheckboxTableViewer)this.getMasterViewer();
                if (checkViewer.getChecked((Object)this.selectedNamespaceDefinition)) {
                    String defaultLocation = this.selectedNamespaceDefinition.getDefaultSchemaLocation((IResource)this.getConfigEditor().getResourceFile());
                    if (this.selectedNamespaceDefinition.getSchemaLocations().size() > 0 || defaultLocation != null) {
                        this.versionViewer.getControl().setEnabled(true);
                    } else {
                        this.versionViewer.getControl().setEnabled(false);
                    }
                } else {
                    this.versionViewer.getControl().setEnabled(false);
                }
            }
        }
        this.versionViewer.refresh();
        super.refresh();
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object obj;
        INamespaceDefinition oldDefinition = this.selectedNamespaceDefinition;
        this.selectedNamespaceDefinition = null;
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel != null && (obj = sel.getFirstElement()) != null && obj instanceof INamespaceDefinition) {
            this.selectedNamespaceDefinition = obj != oldDefinition ? (INamespaceDefinition)obj : oldDefinition;
            this.versionViewer.setInput((Object)this.selectedNamespaceDefinition);
        }
        super.selectionChanged(part, selection);
    }

    private class VersionContentProvider
    implements IStructuredContentProvider {
        private VersionContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            if (obj instanceof INamespaceDefinition) {
                HashSet<String> elements = new HashSet<String>();
                String defaultLocation = ((INamespaceDefinition)obj).getDefaultSchemaLocation((IResource)NamespacesDetailsPart.this.getConfigEditor().getResourceFile());
                if (defaultLocation != null) {
                    elements.add(defaultLocation);
                }
                elements.addAll(((INamespaceDefinition)obj).getSchemaLocations());
                return elements.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class VersionLabelProvider
    extends LabelProvider {
        private VersionLabelProvider() {
        }

        public Image getImage(Object element) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String label = (String)element;
                if (NamespacesDetailsPart.this.selectedNamespaceDefinition != null && label.equals(NamespacesDetailsPart.this.selectedNamespaceDefinition.getDefaultSchemaLocation((IResource)NamespacesDetailsPart.this.getConfigEditor().getResourceFile()))) {
                    label = String.valueOf(label) + " " + Messages.getString("NamespacesDetailsPart.DEFAULT_VERSION_SUFFIX");
                }
                return label;
            }
            return super.getText(element);
        }
    }
}

