/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.java.rule.controversial.DaaRuleViolation;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DataflowAnomalyTableContentProvider
implements IStructuredContentProvider {
    private static final int MAX_ROWS = 200;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Iterator) {
            Iterator violationsIterator = (Iterator)inputElement;
            ArrayList<DaaRuleViolation> violations = new ArrayList<DaaRuleViolation>();
            int count = 0;
            while (violationsIterator.hasNext() && count < 200) {
                DaaRuleViolation violation = (DaaRuleViolation)violationsIterator.next();
                if (!DataflowAnomalyTableContentProvider.violationIsInList(violation, violations)) {
                    violations.add(violation);
                }
                ++count;
            }
            return violations.toArray(new DaaRuleViolation[violations.size()]);
        }
        return Util.EMPTY_ARRAY;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static boolean violationIsInList(DaaRuleViolation newViolation, List<DaaRuleViolation> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (DaaRuleViolation violation : list) {
            if (!violation.getVariableName().equals(newViolation.getVariableName()) || !violation.getType().equals(newViolation.getType()) || violation.getBeginLine() != newViolation.getBeginLine() || violation.getEndLine() != newViolation.getEndLine()) continue;
            return true;
        }
        return false;
    }
}

