/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleDialog;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractViolationSelectionAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;

public class ShowRuleAction
extends AbstractViolationSelectionAction {
    private Shell shell;

    public ShowRuleAction(TableViewer viewer, Shell shell) {
        super(viewer);
    }

    @Override
    protected String textId() {
        return "view.action.show_rule";
    }

    @Override
    protected String imageId() {
        return null;
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.show_rule";
    }

    @Override
    protected boolean canExecute() {
        return super.canExecute() && this.allSelectionsDenoteSameRule();
    }

    private boolean allSelectionsDenoteSameRule() {
        IMarker[] markers = this.getSelectedViolations();
        return MarkerUtil.commonRuleNameAmong(markers) != null;
    }

    public void run() {
        Rule selectedRule = this.getSelectedViolationRule();
        if (selectedRule != null) {
            RuleDialog ruleDialog = new RuleDialog(this.shell, selectedRule, false);
            ruleDialog.open();
        }
    }

    public Rule getSelectedViolationRule() {
        Rule rule = null;
        try {
            IMarker[] markers = this.getSelectedViolations();
            if (markers != null) {
                rule = PMDPlugin.getDefault().getPreferencesManager().getRuleSet().getRuleByName(MarkerUtil.ruleNameFor(markers[0]));
            }
        }
        catch (RuntimeException e) {
            ShowRuleAction.logErrorByKey("message.error.runtime_exception", e);
        }
        return rule;
    }
}

