/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PriorityFilterAction
extends Action {
    private ViolationOutline outlineView;
    private ViolationOverview overviewView;
    private PriorityFilter priorityFilter;
    private final RulePriority priority;

    private PriorityFilterAction(ViewerFilter[] filters, RulePriority thePriority) {
        this.priority = thePriority;
        this.setFilterFrom(filters);
        this.setupActionLook();
    }

    public PriorityFilterAction(RulePriority prio, ViolationOutline view) {
        this(view.getFilters(), prio);
        this.outlineView = view;
    }

    public PriorityFilterAction(RulePriority prio, ViolationOverview view) {
        this(view.getViewer().getFilters(), prio);
        this.overviewView = view;
    }

    private void setFilterFrom(ViewerFilter[] filters) {
        ViewerFilter[] viewerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof PriorityFilter) {
                this.priorityFilter = (PriorityFilter)filter;
            }
            ++n2;
        }
    }

    private void setupActionLook() {
        PriorityDescriptor desc = UISettings.descriptorFor(this.priority);
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)desc.getImage(Display.getCurrent())));
        this.setText(desc.label);
        String toolTip = String.format(desc.filterText, UISettings.labelFor(this.priority));
        this.setToolTipText(toolTip);
    }

    public int getStyle() {
        return 2;
    }

    public void run() {
        if (this.isChecked()) {
            this.priorityFilter.addPriorityToList(this.priority.getPriority());
        } else {
            this.priorityFilter.removePriorityFromList(this.priority.getPriority());
        }
        if (this.outlineView != null) {
            this.outlineView.refresh();
        } else if (this.overviewView != null) {
            this.overviewView.refresh();
        }
    }
}

