/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.reports;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;

public class ReportManager {
    private final Renderer[] allRenderers = this.availableRenderers2();
    public static final ReportManager instance = new ReportManager();
    public static String DefaultReportPropertyFilename = "reportProperties.xml";

    private ReportManager() {
    }

    public Renderer[] allRenderers() {
        return this.allRenderers;
    }

    public Renderer[] availableRenderers2() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        for (String reportName : RendererFactory.REPORT_FORMAT_TO_RENDERER.keySet()) {
            renderers.add(RendererFactory.createRenderer((String)reportName, (Properties)new Properties()));
        }
        return renderers.toArray(new Renderer[renderers.size()]);
    }

    public List<Renderer> activeRenderers() {
        ArrayList<Renderer> actives = new ArrayList<Renderer>();
        IPreferences prefs = PMDPlugin.getDefault().loadPreferences();
        Renderer[] rendererArray = this.allRenderers;
        int n = this.allRenderers.length;
        int n2 = 0;
        while (n2 < n) {
            Renderer renderer = rendererArray[n2];
            if (prefs.isActiveRenderer(renderer.getName())) {
                actives.add(renderer);
            }
            ++n2;
        }
        return actives;
    }

    public static String asString(Map<String, String> propertyDefinitions) {
        if (propertyDefinitions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] keys = propertyDefinitions.keySet().toArray(new String[propertyDefinitions.size()]);
        sb.append(keys[0]).append(": ").append(propertyDefinitions.get(keys[0]));
        int i = 1;
        while (i < keys.length) {
            sb.append(", ").append(keys[i]).append(": ").append(propertyDefinitions.get(keys[i]));
            ++i;
        }
        return sb.toString();
    }

    private static String keyOf(Renderer renderer, PropertyDescriptor<?> desc) {
        return String.valueOf(renderer.getName()) + "__" + desc.name();
    }

    public static void loadReportProperties() {
        ReportManager.loadReportProperties(DefaultReportPropertyFilename);
    }

    public static void saveReportProperties() {
        ReportManager.saveReportProperties(DefaultReportPropertyFilename);
    }

    private static boolean loadReportProperties(String propertyFilename) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(propertyFilename);
                props.loadFromXML(fis);
            }
            catch (Exception exception) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception2) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {}
        Renderer[] rendererArray = instance.allRenderers();
        int n = rendererArray.length;
        int n2 = 0;
        while (n2 < n) {
            Renderer renderer = rendererArray[n2];
            for (PropertyDescriptor pDesc : renderer.getPropertyDescriptors()) {
                String key = ReportManager.keyOf(renderer, pDesc);
                if (!props.containsKey(key)) continue;
                Object value = pDesc.valueFrom((String)props.get(key));
                renderer.setProperty(pDesc, value);
            }
            ++n2;
        }
        return true;
    }

    private static void saveReportProperties(String propertyFilename) {
        block16: {
            Properties props = new Properties();
            Renderer[] rendererArray = instance.allRenderers();
            int n = rendererArray.length;
            int n2 = 0;
            while (n2 < n) {
                Renderer renderer = rendererArray[n2];
                Map valuesByProp = renderer.getPropertiesByPropertyDescriptor();
                for (Map.Entry entry : valuesByProp.entrySet()) {
                    PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
                    props.put(ReportManager.keyOf(renderer, desc), desc.asDelimitedString(entry.getValue()));
                }
                ++n2;
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(propertyFilename);
                    props.storeToXML(fos, "asdf");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block16;
                    }
                    catch (Exception exception) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

